/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.inject.Injector;
import com.proofpoint.reporting.Mapping;
import com.proofpoint.reporting.Reference;
import com.proofpoint.reporting.ReportExporter;
import java.util.HashMap;
import java.util.Set;
import javax.inject.Inject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

class GuiceReportExporter {
    private final ReportExporter reportExporter;

    @Inject
    GuiceReportExporter(Set<Mapping> mappings, ReportExporter reportExporter, Injector injector) throws MalformedObjectNameException {
        this.reportExporter = reportExporter;
        this.export(mappings, injector);
    }

    private void export(Set<Mapping> mappings, Injector injector) throws MalformedObjectNameException {
        HashMap<Reference, Mapping> exported = new HashMap<Reference, Mapping>();
        for (Mapping mapping : mappings) {
            Object object = injector.getInstance(mapping.getKey());
            String legacyName = mapping.getLegacyName();
            if (legacyName != null) {
                this.reportExporter.export(new ObjectName(legacyName), object);
                continue;
            }
            Mapping oldMapping = exported.putIfAbsent(new Reference(object), mapping);
            if (oldMapping != null && oldMapping.getKey().equals(mapping.getKey()) && oldMapping.isApplicationPrefix() == mapping.isApplicationPrefix() && oldMapping.getNamePrefix().equals(mapping.getNamePrefix()) && oldMapping.getTags().equals(mapping.getTags())) continue;
            this.reportExporter.export(object, mapping.isApplicationPrefix(), mapping.getNamePrefix(), mapping.getTags());
        }
    }
}

