/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.proofpoint.reporting.AnnotationUtils;
import com.proofpoint.reporting.AutoValue_HealthBean;
import com.proofpoint.reporting.HealthBeanAttribute;
import com.proofpoint.reporting.HealthBeanAttributeBuilder;
import com.proofpoint.reporting.HealthCheck;
import com.proofpoint.reporting.HealthCheckRemoveFromRotation;
import com.proofpoint.reporting.HealthCheckRestartDesired;
import com.proofpoint.reporting.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

@AutoValue
abstract class HealthBean {
    HealthBean() {
    }

    public abstract Collection<HealthBeanAttribute> getAttributes();

    public static HealthBean forTarget(Object target) {
        Objects.requireNonNull(target, "target is null");
        ImmutableList.Builder attributes = ImmutableList.builder();
        for (Map.Entry<Method, Method> entry : AnnotationUtils.findAnnotatedMethods(target.getClass(), HealthCheck.class, HealthCheckRemoveFromRotation.class, HealthCheckRestartDesired.class).entrySet()) {
            Method concreteMethod = entry.getKey();
            Method annotatedMethod = entry.getValue();
            if (!ReflectionUtils.isValidGetter(concreteMethod)) {
                throw new RuntimeException("healthcheck annotation on non-getter " + annotatedMethod.toGenericString());
            }
            attributes.addAll(new HealthBeanAttributeBuilder().onInstance(target).withConcreteGetter(concreteMethod).withAnnotatedGetter(annotatedMethod).build());
        }
        for (Field field : AnnotationUtils.findAnnotatedFields(target.getClass(), HealthCheck.class, HealthCheckRemoveFromRotation.class, HealthCheckRestartDesired.class)) {
            if (!AtomicReference.class.isAssignableFrom(field.getType())) {
                throw new RuntimeException("healthcheck annotation on non-AtomicReference field " + field.toGenericString());
            }
            attributes.addAll(new HealthBeanAttributeBuilder().onInstance(target).withField(field).build());
        }
        return new AutoValue_HealthBean((Collection<HealthBeanAttribute>)attributes.build());
    }
}

