/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.proofpoint.reporting.AnnotationUtils;
import com.proofpoint.reporting.FieldHealthBeanAttribute;
import com.proofpoint.reporting.HealthBean;
import com.proofpoint.reporting.HealthBeanAttribute;
import com.proofpoint.reporting.HealthCheck;
import com.proofpoint.reporting.HealthCheckRemoveFromRotation;
import com.proofpoint.reporting.HealthCheckRestartDesired;
import com.proofpoint.reporting.MethodHealthBeanAttribute;
import com.proofpoint.reporting.ReflectionUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

class HealthBeanAttributeBuilder {
    private Object target;
    private Method concreteGetter;
    private Method annotatedGetter;
    private Field field;

    HealthBeanAttributeBuilder() {
    }

    HealthBeanAttributeBuilder onInstance(Object target) {
        this.target = Objects.requireNonNull(target, "target is null");
        return this;
    }

    HealthBeanAttributeBuilder withConcreteGetter(Method concreteGetter) {
        Objects.requireNonNull(concreteGetter, "concreteGetter is null");
        Preconditions.checkArgument((boolean)ReflectionUtils.isValidGetter(concreteGetter), (Object)("Method is not a valid getter: " + concreteGetter));
        this.concreteGetter = concreteGetter;
        return this;
    }

    HealthBeanAttributeBuilder withAnnotatedGetter(Method annotatedGetter) {
        Objects.requireNonNull(annotatedGetter, "annotatedGetter is null");
        Preconditions.checkArgument((boolean)ReflectionUtils.isValidGetter(annotatedGetter), (Object)("Method is not a valid getter: " + annotatedGetter));
        this.annotatedGetter = annotatedGetter;
        return this;
    }

    HealthBeanAttributeBuilder withField(Field field) {
        Objects.requireNonNull(field, "field is null");
        Preconditions.checkArgument((boolean)AtomicReference.class.isAssignableFrom(field.getType()), (Object)("Field is not an AtomicReference: " + field));
        this.field = field;
        return this;
    }

    Collection<? extends HealthBeanAttribute> build() {
        HealthBeanAttribute.Type type;
        String description;
        Preconditions.checkArgument((this.target != null ? 1 : 0) != 0, (Object)"HealthBeanAttribute must have a target object");
        if (this.field != null) {
            HealthBeanAttribute.Type type2;
            String description2;
            HealthCheckRestartDesired restartDesired = this.field.getAnnotation(HealthCheckRestartDesired.class);
            HealthCheckRemoveFromRotation removeFromRotation = this.field.getAnnotation(HealthCheckRemoveFromRotation.class);
            if (restartDesired != null) {
                if (this.field.getAnnotation(HealthCheck.class) != null) {
                    throw new RuntimeException("field " + this.field + " cannot have both @HealthCheck and @HealthCheckRestartDesired annotations");
                }
                if (this.field.getAnnotation(HealthCheckRemoveFromRotation.class) != null) {
                    throw new RuntimeException("field " + this.field + " cannot have both @HealthCheckRemoveFromRotation and @HealthCheckRestartDesired annotations");
                }
                description2 = restartDesired.value();
                type2 = HealthBeanAttribute.Type.RESTART;
            } else if (removeFromRotation != null) {
                if (this.field.getAnnotation(HealthCheck.class) != null) {
                    throw new RuntimeException("field " + this.field + " cannot have both @HealthCheck and @HealthCheckRemoveFromRotation annotations");
                }
                description2 = removeFromRotation.value();
                type2 = HealthBeanAttribute.Type.REMOVE_FROM_ROTATION;
            } else {
                description2 = this.field.getAnnotation(HealthCheck.class).value();
                type2 = HealthBeanAttribute.Type.NORMAL;
            }
            return ImmutableList.of((Object)FieldHealthBeanAttribute.fieldHealthBeanAttribute(description2, type2, this.target, this.field));
        }
        if (AnnotationUtils.isFlatten(this.annotatedGetter) || AnnotationUtils.isNested(this.annotatedGetter)) {
            Preconditions.checkArgument((this.concreteGetter != null ? 1 : 0) != 0, (Object)"Nested/Flattened HealthBeanAttribute must have a concrete getter");
            Object value = null;
            try {
                value = this.concreteGetter.invoke(this.target, new Object[0]);
            }
            catch (Exception type2) {
                // empty catch block
            }
            if (value == null) {
                return Collections.emptySet();
            }
            return HealthBean.forTarget(value).getAttributes();
        }
        Preconditions.checkArgument((this.concreteGetter != null ? 1 : 0) != 0, (Object)"HealthBeanAttribute must have a concrete getter");
        HealthCheckRestartDesired restartDesired = this.annotatedGetter.getAnnotation(HealthCheckRestartDesired.class);
        HealthCheckRemoveFromRotation removeFromRotation = this.annotatedGetter.getAnnotation(HealthCheckRemoveFromRotation.class);
        if (restartDesired != null) {
            if (this.annotatedGetter.getAnnotation(HealthCheck.class) != null) {
                throw new RuntimeException("Method " + this.annotatedGetter + " cannot have both @HealthCheck and @HealthCheckRestartDesired annotations");
            }
            if (this.annotatedGetter.getAnnotation(HealthCheckRemoveFromRotation.class) != null) {
                throw new RuntimeException("Method " + this.annotatedGetter + " cannot have both @HealthCheckRemoveFromRotation and @HealthCheckRestartDesired annotations");
            }
            description = restartDesired.value();
            type = HealthBeanAttribute.Type.RESTART;
        } else if (removeFromRotation != null) {
            if (this.annotatedGetter.getAnnotation(HealthCheck.class) != null) {
                throw new RuntimeException("Method " + this.annotatedGetter + " cannot have both @HealthCheck and @HealthCheckRemoveFromRotation annotations");
            }
            description = removeFromRotation.value();
            type = HealthBeanAttribute.Type.REMOVE_FROM_ROTATION;
        } else {
            description = this.annotatedGetter.getAnnotation(HealthCheck.class).value();
            type = HealthBeanAttribute.Type.NORMAL;
        }
        return ImmutableList.of((Object)MethodHealthBeanAttribute.methodHealthBeanAttribute(description, type, this.target, this.concreteGetter));
    }
}

