/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.collect.ImmutableMap;
import com.proofpoint.reporting.HealthBeanAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.management.InstanceAlreadyExistsException;

class HealthBeanRegistry {
    private final ConcurrentMap<String, HealthBeanAttribute> healthAttributes = new ConcurrentHashMap<String, HealthBeanAttribute>();

    HealthBeanRegistry() {
    }

    Map<String, HealthBeanAttribute> getHealthAttributes() {
        return ImmutableMap.copyOf(this.healthAttributes);
    }

    public void register(HealthBeanAttribute healthBeanAttribute, String description) throws InstanceAlreadyExistsException {
        if (description == null) {
            throw new UnsupportedOperationException("Only explicit description supported at this time");
        }
        if (this.healthAttributes.putIfAbsent(description, healthBeanAttribute) != null) {
            throw new InstanceAlreadyExistsException(description + " is already registered");
        }
    }

    public void unregister(String description) {
        this.healthAttributes.remove(description);
    }
}

