/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.proofpoint.reporting.HealthBean;
import com.proofpoint.reporting.HealthBeanAttribute;
import com.proofpoint.reporting.HealthBeanRegistry;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.management.InstanceAlreadyExistsException;

public class HealthExporter {
    private final HealthBeanRegistry registry;

    @Inject
    HealthExporter(HealthBeanRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
    }

    public void export(@Nullable String instanceName, Object object) throws InstanceAlreadyExistsException {
        HealthBean healthBean = HealthBean.forTarget(object);
        for (HealthBeanAttribute attribute : healthBean.getAttributes()) {
            StringBuilder sb = new StringBuilder(attribute.getDescription());
            if (instanceName != null) {
                sb.append(" (").append(instanceName).append(")");
            }
            this.registry.register(attribute, sb.toString());
        }
    }
}

