/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.Ticker;
import com.proofpoint.reporting.BucketIdProvider;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class MinuteBucketIdProvider
implements BucketIdProvider {
    private static final long ONE_MINUTE_IN_NANOS = 60000000000L;
    private final Ticker ticker;
    private final long initialValue;

    @Inject
    public MinuteBucketIdProvider() {
        this(Ticker.systemTicker());
    }

    public MinuteBucketIdProvider(Ticker ticker) {
        this.ticker = ticker;
        this.initialValue = ticker.read();
    }

    @Override
    public BucketIdProvider.BucketId get() {
        long nanosSinceInitial = this.ticker.read() - this.initialValue;
        int id = (int)(nanosSinceInitial / 60000000000L);
        long nanosSinceBoundary = nanosSinceInitial % 60000000000L;
        long timeAtBoundary = TimeUnit.MILLISECONDS.toNanos(System.currentTimeMillis()) - nanosSinceBoundary;
        return BucketIdProvider.BucketId.bucketId(id, timeAtBoundary);
    }

    public long getLastSystemTimeMillis() {
        long nanosSinceBoundary = (this.ticker.read() - this.initialValue) % 60000000000L;
        return System.currentTimeMillis() - TimeUnit.NANOSECONDS.toMillis(nanosSinceBoundary);
    }
}

