/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.CaseFormat;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeOperationsException;

final class ReflectionUtils {
    private static final Pattern getterOrSetterPattern = Pattern.compile("(get|set|is)(.+)");

    private ReflectionUtils() {
    }

    static Object invoke(Object target, Method method) throws MBeanException, ReflectionException {
        Objects.requireNonNull(target, "target is null");
        Objects.requireNonNull(method, "method is null");
        try {
            return method.invoke(target, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw new MBeanException((RuntimeException)targetException, "RuntimeException occurred while invoking " + ReflectionUtils.toSimpleName(method));
            }
            if (targetException instanceof ReflectionException) {
                throw (ReflectionException)targetException;
            }
            if (targetException instanceof MBeanException) {
                throw (MBeanException)targetException;
            }
            if (targetException instanceof Exception) {
                throw new MBeanException((Exception)targetException, "Exception occurred while invoking " + ReflectionUtils.toSimpleName(method));
            }
            if (targetException instanceof Error) {
                throw new RuntimeErrorException((Error)targetException, "Error occurred while invoking " + ReflectionUtils.toSimpleName(method));
            }
            throw new RuntimeErrorException((Error)((Object)new AssertionError((Object)targetException)), "Unexpected throwable occurred while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (RuntimeException e) {
            throw new RuntimeOperationsException(e, "RuntimeException occurred while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e, "IllegalAccessException occurred while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (Error err) {
            throw new RuntimeErrorException(err, "Error occurred while invoking " + ReflectionUtils.toSimpleName(method));
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception occurred while invoking " + ReflectionUtils.toSimpleName(method));
        }
    }

    private static String toSimpleName(Method method) {
        return method.getName() + "()";
    }

    static boolean isGetter(Method method) {
        String methodName = method.getName();
        return (methodName.startsWith("get") || methodName.startsWith("is")) && ReflectionUtils.isValidGetter(method);
    }

    static String getAttributeName(Method method) {
        Matcher matcher = getterOrSetterPattern.matcher(method.getName());
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, method.getName());
    }

    static String getAttributeName(Field field) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, field.getName());
    }

    static boolean isValidGetter(Method getter) {
        if (getter == null) {
            throw new NullPointerException("getter is null");
        }
        if (getter.getParameterTypes().length != 0) {
            return false;
        }
        return !getter.getReturnType().equals(Void.TYPE);
    }
}

