/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Named;
import com.proofpoint.reporting.AnnotatedReportBinder;
import com.proofpoint.reporting.Mapping;
import com.proofpoint.reporting.NamedReportBinder;
import com.proofpoint.reporting.ReportCollectionBinder;
import java.util.Objects;

public class ReportBinder {
    private final Binder binder;
    private final Multibinder<Mapping> multibinder;

    private ReportBinder(Binder binder) {
        this.binder = Objects.requireNonNull(binder, "binder is null").skipSources(new Class[]{this.getClass()});
        this.multibinder = Multibinder.newSetBinder((Binder)binder, Mapping.class);
    }

    public static ReportBinder reportBinder(Binder binder) {
        return new ReportBinder(binder);
    }

    public AnnotatedReportBinder export(Class<?> clazz) {
        Mapping mapping = this.createMapping(Key.get(clazz));
        return new AnnotatedReportBinder(mapping);
    }

    public NamedReportBinder export(Key<?> key) {
        Mapping mapping = this.createMapping(key);
        return new NamedReportBinder(mapping);
    }

    public <T> ReportCollectionBinder<T> bindReportCollection(Class<T> iface) {
        return new ReportCollectionBinder<T>(this.binder, iface);
    }

    private Mapping createMapping(Key<?> key) {
        String namePrefix = key.getAnnotation() != null ? (key.getAnnotation() instanceof Named ? key.getTypeLiteral().getRawType().getSimpleName() + "." + ((Named)key.getAnnotation()).value() : key.getTypeLiteral().getRawType().getSimpleName() + "." + key.getAnnotation().annotationType().getSimpleName()) : (key.getAnnotationType() != null ? key.getTypeLiteral().getRawType().getSimpleName() + "." + key.getAnnotationType().getSimpleName() : key.getTypeLiteral().getRawType().getSimpleName());
        Mapping mapping = new Mapping(key, namePrefix);
        this.multibinder.addBinding().toInstance((Object)mapping);
        return mapping;
    }
}

