/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.CaseFormat;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.reporting.Key;
import com.proofpoint.reporting.ReportExporter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ReportCollectionFactory {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final Method OBJECT_EQUALS_METHOD;
    private static final Method OBJECT_HASH_CODE_METHOD;
    private static final Method OBJECT_TO_STRING_METHOD;
    private final Ticker ticker;
    private final ReportExporter reportExporter;

    @Inject
    public ReportCollectionFactory(ReportExporter reportExporter) {
        this(reportExporter, Ticker.systemTicker());
    }

    protected ReportCollectionFactory(ReportExporter reportExporter, Ticker ticker) {
        this.reportExporter = reportExporter;
        this.ticker = ticker;
    }

    public <T> T createReportCollection(Class<T> aClass) {
        Objects.requireNonNull(aClass, "class is null");
        return (T)Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{aClass}, (InvocationHandler)new StatInvocationHandler(aClass, false, Optional.of(aClass.getSimpleName()), (Map<String, String>)ImmutableMap.of()));
    }

    public <T> T createReportCollection(Class<T> aClass, boolean applicationPrefix, @Nullable String namePrefix, Map<String, String> tags) {
        Objects.requireNonNull(aClass, "class is null");
        Objects.requireNonNull(tags, "tags is null");
        if ("".equals(namePrefix)) {
            namePrefix = null;
        }
        return (T)Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{aClass}, (InvocationHandler)new StatInvocationHandler(aClass, applicationPrefix, Optional.ofNullable(namePrefix), (Map<String, String>)ImmutableMap.copyOf(tags)));
    }

    @Deprecated
    public <T> T createReportCollection(Class<T> aClass, String name) {
        ObjectName objectName;
        Objects.requireNonNull(aClass, "class is null");
        Objects.requireNonNull(name, "name is null");
        Optional<String> namePrefix = Optional.empty();
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder();
        try {
            objectName = ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        int index = objectName.getDomain().length();
        if (name.charAt(index++) != ':') {
            throw new RuntimeException("Unable to parse ObjectName " + name);
        }
        while (index < name.length()) {
            String value;
            int separatorIndex = name.indexOf(61, index);
            String key = name.substring(index, separatorIndex);
            if (name.charAt(++separatorIndex) == '\"') {
                char c;
                StringBuilder sb = new StringBuilder();
                while ((c = name.charAt(++separatorIndex)) != '\"') {
                    if (c == '\\') {
                        c = name.charAt(++separatorIndex);
                    }
                    sb.append(c);
                }
                if (name.charAt(++separatorIndex) != ',') {
                    throw new RuntimeException("Unable to parse ObjectName " + name);
                }
                value = sb.toString();
                index = separatorIndex + 1;
            } else {
                index = name.indexOf(44, separatorIndex);
                if (index == -1) {
                    index = name.length();
                }
                value = name.substring(separatorIndex, index);
                ++index;
            }
            if ("type".equals(key)) {
                Preconditions.checkArgument((!namePrefix.isPresent() ? 1 : 0) != 0, (Object)("ObjectName " + name + " has two type parameters"));
                namePrefix = Optional.of(value);
                continue;
            }
            Preconditions.checkArgument((!"name".equals(key) ? 1 : 0) != 0, (Object)("ObjectName" + name + " not permitted to have a name parameter"));
            tagsBuilder.put((Object)key, (Object)value);
        }
        return (T)Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{aClass}, (InvocationHandler)new StatInvocationHandler(aClass, false, namePrefix, (Map<String, String>)tagsBuilder.build()));
    }

    protected Supplier<Object> getReturnValueSupplier(Method method) {
        Constructor<?> constructor;
        try {
            constructor = method.getReturnType().getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(ReportCollectionFactory.methodName(method) + " return type " + method.getReturnType().getSimpleName() + " has no public no-arg constructor");
        }
        return () -> {
            try {
                return constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private static String methodName(Method method) {
        StringBuilder builder = new StringBuilder(method.getDeclaringClass().getName());
        builder.append(".").append(method.getName()).append('(');
        boolean first = true;
        for (Class<?> type : method.getParameterTypes()) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(type.getName());
            first = false;
        }
        builder.append(')');
        return builder.toString();
    }

    static {
        try {
            OBJECT_EQUALS_METHOD = Object.class.getDeclaredMethod("equals", Object.class);
            OBJECT_HASH_CODE_METHOD = Object.class.getDeclaredMethod("hashCode", new Class[0]);
            OBJECT_TO_STRING_METHOD = Object.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private class CacheImplementation
    implements MethodImplementation {
        private final LoadingCache<List<Optional<String>>, Object> loadingCache;
        @GuardedBy(value="registeredMap")
        private final Map<List<Optional<String>>, Object> registeredMap = new HashMap<List<Optional<String>>, Object>();
        @GuardedBy(value="registeredMap")
        private final Set<Object> reinsertedSet = new HashSet<Object>();

        CacheImplementation(Method method, boolean applicationPrefix, String namePrefix, final Map<String, String> tags) {
            Preconditions.checkState((method.getParameterTypes().length != 0 ? 1 : 0) != 0);
            final Supplier<Object> returnValueSupplier = ReportCollectionFactory.this.getReturnValueSupplier(method);
            ImmutableList.Builder keyNameBuilder = ImmutableList.builder();
            int argPosition = 0;
            for (Annotation[] annotations : method.getParameterAnnotations()) {
                ++argPosition;
                boolean found = false;
                for (Annotation annotation : annotations) {
                    if (!Key.class.isAssignableFrom(annotation.annotationType())) continue;
                    String keyName = ((Key)annotation).value();
                    Preconditions.checkArgument((!tags.containsKey(keyName) ? 1 : 0) != 0, (Object)(ReportCollectionFactory.methodName(method) + " @Key(\"" + keyName + "\") duplicates tag on entire report collection"));
                    keyNameBuilder.add((Object)keyName);
                    found = true;
                    break;
                }
                if (found) continue;
                throw new RuntimeException(ReportCollectionFactory.methodName(method) + " parameter " + argPosition + " has no @com.proofpoint.reporting.Key annotation");
            }
            ImmutableList keyNames = keyNameBuilder.build();
            this.loadingCache = CacheBuilder.newBuilder().ticker(ReportCollectionFactory.this.ticker).expireAfterAccess(15L, TimeUnit.MINUTES).removalListener((RemovalListener)new UnexportRemovalListener()).build((CacheLoader)new CacheLoader<List<Optional<String>>, Object>((List)keyNames, applicationPrefix, namePrefix){
                final /* synthetic */ List val$keyNames;
                final /* synthetic */ boolean val$applicationPrefix;
                final /* synthetic */ String val$namePrefix;
                {
                    this.val$keyNames = list;
                    this.val$applicationPrefix = bl;
                    this.val$namePrefix = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object load(List<Optional<String>> key) {
                    Object returnValue = returnValueSupplier.get();
                    Map map = CacheImplementation.this.registeredMap;
                    synchronized (map) {
                        Object existingStat = CacheImplementation.this.registeredMap.get(key);
                        if (existingStat != null) {
                            CacheImplementation.this.reinsertedSet.add(existingStat);
                            return existingStat;
                        }
                        CacheImplementation.this.registeredMap.put(key, returnValue);
                        ImmutableMap.Builder tagBuilder = ImmutableMap.builder();
                        tagBuilder.putAll(tags);
                        for (int i = 0; i < this.val$keyNames.size(); ++i) {
                            Optional<String> keyValue = key.get(i);
                            if (!keyValue.isPresent()) continue;
                            tagBuilder.put(this.val$keyNames.get(i), (Object)keyValue.get());
                        }
                        ReportCollectionFactory.this.reportExporter.export(returnValue, this.val$applicationPrefix, this.val$namePrefix, (Map<String, String>)tagBuilder.build());
                    }
                    return returnValue;
                }
            });
        }

        @Override
        public Object get(List<Optional<String>> key) throws ExecutionException {
            return this.loadingCache.get(key);
        }

        private class UnexportRemovalListener
        implements RemovalListener<List<Optional<String>>, Object> {
            private UnexportRemovalListener() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<List<Optional<String>>, Object> notification) {
                Map map = CacheImplementation.this.registeredMap;
                synchronized (map) {
                    if (CacheImplementation.this.reinsertedSet.remove(notification.getValue())) {
                        return;
                    }
                    ReportCollectionFactory.this.reportExporter.unexportObject(notification.getValue());
                    CacheImplementation.this.registeredMap.remove(notification.getKey());
                }
            }
        }
    }

    private class SingletonImplementation
    implements MethodImplementation {
        private final Object returnValue;

        SingletonImplementation(Method method, boolean applicationPrefix, String namePrefix, Map<String, String> tags) {
            Preconditions.checkArgument((method.getParameterTypes().length == 0 ? 1 : 0) != 0, (Object)"method has parameters");
            this.returnValue = ReportCollectionFactory.this.getReturnValueSupplier(method).get();
            ReportCollectionFactory.this.reportExporter.export(this.returnValue, applicationPrefix, namePrefix, tags);
        }

        @Override
        public Object get(List<Optional<String>> key) {
            return this.returnValue;
        }
    }

    private static interface MethodImplementation {
        public Object get(List<Optional<String>> var1) throws ExecutionException;
    }

    private class StatInvocationHandler
    implements InvocationHandler {
        private final Map<Method, MethodImplementation> implementationMap;

        <T> StatInvocationHandler(Class<T> aClass, boolean applicationPrefix, Optional<String> namePrefix, Map<String, String> tags) {
            ImmutableMap.Builder cacheBuilder = ImmutableMap.builder();
            for (Method method : aClass.getMethods()) {
                StringBuilder builder = new StringBuilder();
                if (namePrefix.isPresent()) {
                    builder.append(namePrefix.get()).append('.');
                }
                builder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, method.getName()));
                if (method.getParameterTypes().length == 0) {
                    cacheBuilder.put((Object)method, (Object)new SingletonImplementation(method, applicationPrefix, builder.toString(), tags));
                    continue;
                }
                cacheBuilder.put((Object)method, (Object)new CacheImplementation(method, applicationPrefix, builder.toString(), tags));
            }
            this.implementationMap = cacheBuilder.build();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            ImmutableList.Builder argBuilder = ImmutableList.builder();
            for (Object arg : (Object[])MoreObjects.firstNonNull((Object)args, (Object)EMPTY_OBJECT_ARRAY)) {
                if (arg == null) {
                    argBuilder.add(Optional.empty());
                    continue;
                }
                if (arg instanceof Optional) {
                    argBuilder.add(((Optional)arg).map(Object::toString));
                    continue;
                }
                argBuilder.add(Optional.of(arg.toString()));
            }
            MethodImplementation implementation = this.implementationMap.get(method);
            if (implementation == null) {
                if (OBJECT_EQUALS_METHOD.equals(method)) {
                    return proxy == args[0];
                }
                if (OBJECT_HASH_CODE_METHOD.equals(method)) {
                    return this.hashCode();
                }
                if (OBJECT_TO_STRING_METHOD.equals(method)) {
                    return proxy.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
                }
            }
            return implementation.get((List<Optional<String>>)argBuilder.build());
        }
    }
}

