/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.reporting.ReportCollectionFactory;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;

class ReportCollectionProvider<T>
implements Provider<T> {
    private final Class<T> iface;
    private final AtomicBoolean provided = new AtomicBoolean();
    private boolean applicationPrefix = false;
    private String namePrefix;
    private Map<String, String> tags = ImmutableMap.of();
    private String legacyName = null;
    private ReportCollectionFactory reportCollectionFactory;

    ReportCollectionProvider(Class<T> iface) {
        this.iface = Objects.requireNonNull(iface, "iface is null");
        this.namePrefix = iface.getSimpleName();
    }

    @Inject
    public void setReportCollectionFactory(ReportCollectionFactory reportCollectionFactory) {
        this.reportCollectionFactory = reportCollectionFactory;
    }

    public T get() {
        this.provided.set(true);
        if (this.legacyName == null) {
            return this.reportCollectionFactory.createReportCollection(this.iface, this.applicationPrefix, this.namePrefix, this.tags);
        }
        return this.reportCollectionFactory.createReportCollection(this.iface, this.legacyName);
    }

    public void setApplicationPrefix(boolean applicationPrefix) {
        this.applicationPrefix = applicationPrefix;
    }

    void setNamePrefix(@Nullable String namePrefix) {
        this.namePrefix = namePrefix;
    }

    void setTags(Map<String, String> tags) {
        this.tags = ImmutableMap.copyOf(tags);
    }

    void setLegacyName(String legacyName) {
        Preconditions.checkState((!this.provided.get() ? 1 : 0) != 0, (Object)"report collection already provided");
        this.legacyName = Objects.requireNonNull(legacyName, "legacyName is null");
    }
}

