/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.proofpoint.reporting.BucketIdProvider;
import com.proofpoint.reporting.ReportException;
import com.proofpoint.reporting.ReportedBean;
import com.proofpoint.reporting.ReportedBeanRegistry;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ReportExporter {
    private final ReportedBeanRegistry registry;
    private final BucketIdProvider bucketIdProvider;

    @Inject
    ReportExporter(ReportedBeanRegistry registry, BucketIdProvider bucketIdProvider) {
        this.registry = Objects.requireNonNull(registry, "registry is null");
        this.bucketIdProvider = Objects.requireNonNull(bucketIdProvider, "bucketIdProvider is null");
    }

    public void export(Object object, boolean applicationPrefix, String namePrefix, Map<String, String> tags) {
        ReportedBean reportedBean = ReportedBean.forTarget(object, this.bucketIdProvider);
        if (!reportedBean.getAttributes().isEmpty()) {
            try {
                this.registry.register(object, reportedBean, applicationPrefix, namePrefix, tags);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new ReportException(ReportException.Reason.INSTANCE_ALREADY_EXISTS, e.getMessage());
            }
        }
    }

    public void unexportObject(Object object) {
        try {
            this.registry.unregister(object);
        }
        catch (InstanceNotFoundException e) {
            throw new ReportException(ReportException.Reason.INSTANCE_NOT_FOUND, e.getMessage());
        }
    }

    @Deprecated
    public void export(String name, Object object) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new ReportException(ReportException.Reason.MALFORMED_OBJECT_NAME, e.getMessage());
        }
        this.export(objectName, object);
    }

    @Deprecated
    public void export(ObjectName objectName, Object object) {
        ReportedBean reportedBean = ReportedBean.forTarget(object, this.bucketIdProvider);
        if (!reportedBean.getAttributes().isEmpty()) {
            try {
                this.registry.register(reportedBean, objectName);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new ReportException(ReportException.Reason.INSTANCE_ALREADY_EXISTS, e.getMessage());
            }
        }
    }

    @Deprecated
    public void unexport(String name) {
        ObjectName objectName;
        try {
            objectName = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new ReportException(ReportException.Reason.MALFORMED_OBJECT_NAME, e.getMessage());
        }
        this.unexport(objectName);
    }

    @Deprecated
    public void unexport(ObjectName objectName) {
        try {
            this.registry.unregisterLegacy(objectName);
        }
        catch (InstanceNotFoundException e) {
            throw new ReportException(ReportException.Reason.INSTANCE_NOT_FOUND, e.getMessage());
        }
    }
}

