/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;

public final class ReportUtils {
    private static final Pattern LABEL_NOT_ACCEPTED_CHARACTER_PATTERN = Pattern.compile("[^A-Za-z0-9_]");
    private static final Pattern INITIAL_DIGIT_PATTERN = Pattern.compile("[0-9]");

    private ReportUtils() {
    }

    public static boolean isReportable(Object value) {
        if (value instanceof Double) {
            return !((Double)value).isNaN() && !((Double)value).isInfinite();
        }
        if (value instanceof Float) {
            return !((Float)value).isNaN() && !((Float)value).isInfinite();
        }
        if (value instanceof Long) {
            return !value.equals(Long.MAX_VALUE) && !value.equals(Long.MIN_VALUE);
        }
        if (value instanceof Integer) {
            return !value.equals(Integer.MAX_VALUE) && !value.equals(Integer.MIN_VALUE);
        }
        if (value instanceof Short) {
            return !value.equals((short)Short.MAX_VALUE) && !value.equals((short)Short.MIN_VALUE);
        }
        return true;
    }

    static void writeTags(BufferedWriter writer, Iterable<Map.Entry<String, String>> tags) throws IOException {
        int prefix = 123;
        for (Map.Entry<String, String> tag : tags) {
            writer.append((char)prefix);
            prefix = 44;
            String label = LABEL_NOT_ACCEPTED_CHARACTER_PATTERN.matcher(tag.getKey()).replaceAll("_");
            String value = tag.getValue();
            if (INITIAL_DIGIT_PATTERN.matcher(label).lookingAt()) {
                writer.append('_');
            }
            writer.write(label);
            writer.append("=\"");
            block6: for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '\\': {
                        writer.append("\\\\");
                        continue block6;
                    }
                    case '\"': {
                        writer.append("\\\"");
                        continue block6;
                    }
                    case '\n': {
                        writer.append("\\n");
                        continue block6;
                    }
                    default: {
                        writer.append(c);
                    }
                }
            }
            writer.append("\"");
        }
        if (prefix == 44) {
            writer.append('}');
        }
    }
}

