/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.proofpoint.reporting.AnnotationUtils;
import com.proofpoint.reporting.BucketIdProvider;
import com.proofpoint.reporting.Bucketed;
import com.proofpoint.reporting.BucketedPrometheusBeanAttribute;
import com.proofpoint.reporting.BucketedReportedBeanAttribute;
import com.proofpoint.reporting.PrometheusBeanAttribute;
import com.proofpoint.reporting.ReflectionUtils;
import com.proofpoint.reporting.ReportedAnnotation;
import com.proofpoint.reporting.ReportedBeanAttribute;
import com.proofpoint.reporting.ReportedMethodInfo;
import com.proofpoint.reporting.ReportedMethodInfoBuilder;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

class ReportedBean {
    private static final LoadingCache<Class<?>, Iterable<Map.Entry<Method, Method>>> METHODS_CACHE = CacheBuilder.newBuilder().build(CacheLoader.from(clazz -> AnnotationUtils.findAnnotatedMethods(clazz, ReportedAnnotation.class).entrySet()));
    static Method GET_PREVIOUS_BUCKET;
    private final Map<String, ReportedBeanAttribute> attributes;
    private final Map<String, PrometheusBeanAttribute> prometheusAttributes;

    private ReportedBean(Collection<ReportedBeanAttribute> attributes, Collection<PrometheusBeanAttribute> prometheusAttributes) {
        TreeMap<String, ReportedBeanAttribute> attributesBuilder = new TreeMap<String, ReportedBeanAttribute>();
        for (ReportedBeanAttribute attribute : attributes) {
            attributesBuilder.put(attribute.getName(), attribute);
        }
        this.attributes = Collections.unmodifiableMap(attributesBuilder);
        TreeMap<String, PrometheusBeanAttribute> prometheusAttributesBuilder = new TreeMap<String, PrometheusBeanAttribute>();
        for (PrometheusBeanAttribute attribute : prometheusAttributes) {
            prometheusAttributesBuilder.put(attribute.getName(), attribute);
        }
        this.prometheusAttributes = Collections.unmodifiableMap(prometheusAttributesBuilder);
    }

    Collection<ReportedBeanAttribute> getAttributes() {
        return this.attributes.values();
    }

    Collection<PrometheusBeanAttribute> getPrometheusAttributes() {
        return this.prometheusAttributes.values();
    }

    static ReportedBean forTarget(Object target, BucketIdProvider bucketIdProvider) {
        Objects.requireNonNull(target, "target is null");
        ArrayList<ReportedBeanAttribute> attributes = new ArrayList<ReportedBeanAttribute>();
        ArrayList<PrometheusBeanAttribute> prometheusAttributes = new ArrayList<PrometheusBeanAttribute>();
        if (target instanceof Bucketed) {
            ((Bucketed)target).setBucketIdProvider(bucketIdProvider);
            Bucketed.BucketInfo bucketInfo = null;
            try {
                bucketInfo = (Bucketed.BucketInfo)GET_PREVIOUS_BUCKET.invoke(target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bucketInfo != null) {
                ReportedBean reportedBean = ReportedBean.forTarget(bucketInfo.getBucket(), bucketIdProvider);
                for (ReportedBeanAttribute attribute : reportedBean.getAttributes()) {
                    attributes.add(new BucketedReportedBeanAttribute(target, attribute));
                }
                for (PrometheusBeanAttribute prometheusAttribute : reportedBean.getPrometheusAttributes()) {
                    prometheusAttributes.add(new BucketedPrometheusBeanAttribute(target, prometheusAttribute));
                }
            }
        }
        TreeMap<String, ReportedMethodInfoBuilder> methodInfoBuilders = new TreeMap<String, ReportedMethodInfoBuilder>();
        for (Map.Entry entry : (Iterable)METHODS_CACHE.getUnchecked(target.getClass())) {
            Method concreteMethod = (Method)entry.getKey();
            Method annotatedMethod = (Method)entry.getValue();
            if (!ReflectionUtils.isGetter(concreteMethod)) {
                throw new RuntimeException("report annotation on non-getter " + annotatedMethod.toGenericString());
            }
            String attributeName = ReflectionUtils.getAttributeName(concreteMethod);
            ReportedMethodInfoBuilder attributeBuilder = (ReportedMethodInfoBuilder)methodInfoBuilders.get(attributeName);
            if (attributeBuilder == null) {
                attributeBuilder = new ReportedMethodInfoBuilder(bucketIdProvider).named(attributeName).onInstance(target);
            }
            attributeBuilder = attributeBuilder.withConcreteGetter(concreteMethod).withAnnotatedGetter(annotatedMethod);
            methodInfoBuilders.put(attributeName, attributeBuilder);
        }
        for (ReportedMethodInfoBuilder methodInfoBuilder : methodInfoBuilders.values()) {
            ReportedMethodInfo methodInfo = methodInfoBuilder.build();
            attributes.addAll(methodInfo.getAttributes());
            prometheusAttributes.addAll(methodInfo.getPrometheusAttributes());
        }
        return new ReportedBean(attributes, prometheusAttributes);
    }

    static {
        try {
            Method getPreviousBucket = Bucketed.class.getDeclaredMethod("getPreviousBucket", new Class[0]);
            getPreviousBucket.setAccessible(true);
            GET_PREVIOUS_BUCKET = getPreviousBucket;
        }
        catch (NoSuchMethodException ignored) {
            GET_PREVIOUS_BUCKET = null;
        }
    }
}

