/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.reporting.AutoValue_ReportedBeanRegistry_RegistrationInfo;
import com.proofpoint.reporting.Reference;
import com.proofpoint.reporting.ReportedBean;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.ObjectName;

class ReportedBeanRegistry {
    private static final Pattern QUOTED_PATTERN = Pattern.compile("\"(.*)\"");
    private static final Pattern BACKQUOTE_PATTERN = Pattern.compile("\\\\(.)");
    private final ConcurrentMap<Reference, RegistrationInfo> reportedBeans = new ConcurrentHashMap<Reference, RegistrationInfo>();
    private final ConcurrentMap<ObjectName, ReportedBean> legacyReportedBeans = new ConcurrentHashMap<ObjectName, ReportedBean>();

    ReportedBeanRegistry() {
    }

    Collection<RegistrationInfo> getReportedBeans() {
        return this.reportedBeans.values();
    }

    void register(Object object, ReportedBean reportedBean, boolean applicationPrefix, String namePrefix, Map<String, String> tags) throws InstanceAlreadyExistsException {
        Objects.requireNonNull(object, "object is null");
        if (this.reportedBeans.putIfAbsent(new Reference(object), RegistrationInfo.registrationInfo(reportedBean, applicationPrefix, namePrefix, tags)) != null) {
            throw new InstanceAlreadyExistsException(object + " is already registered");
        }
    }

    void unregister(Object object) throws InstanceNotFoundException {
        if (this.reportedBeans.remove(new Reference(object)) == null) {
            throw new InstanceNotFoundException(object + " not found");
        }
    }

    void register(ReportedBean reportedBean, ObjectName name) throws InstanceAlreadyExistsException {
        if (name == null) {
            throw new UnsupportedOperationException("Only explicit name supported");
        }
        StringBuilder nameBuilder = new StringBuilder();
        if (name.getKeyProperty("type") != null) {
            nameBuilder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, ReportedBeanRegistry.dequote(name.getKeyProperty("type"))));
            if (name.getKeyProperty("name") != null) {
                nameBuilder.append(".");
            }
        }
        if (name.getKeyProperty("name") != null) {
            nameBuilder.append(CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, ReportedBeanRegistry.dequote(name.getKeyProperty("name"))));
        }
        ImmutableMap.Builder tagsBuilder = ImmutableMap.builder();
        for (Map.Entry<String, String> entry : name.getKeyPropertyList().entrySet()) {
            if (entry.getKey().equals("type") || entry.getKey().equals("name")) continue;
            tagsBuilder.put((Object)entry.getKey(), (Object)ReportedBeanRegistry.dequote(entry.getValue()));
        }
        if (this.legacyReportedBeans.putIfAbsent(name, reportedBean) != null) {
            throw new InstanceAlreadyExistsException(name + " is already registered");
        }
        try {
            this.register(reportedBean, reportedBean, false, nameBuilder.toString(), (Map<String, String>)tagsBuilder.build());
        }
        catch (InstanceAlreadyExistsException e) {
            this.legacyReportedBeans.remove(name);
            throw e;
        }
    }

    void unregisterLegacy(ObjectName name) throws InstanceNotFoundException {
        ReportedBean remove = (ReportedBean)this.legacyReportedBeans.remove(name);
        if (remove == null) {
            throw new InstanceNotFoundException(name.getCanonicalName() + " not found");
        }
        this.reportedBeans.remove(new Reference(remove));
    }

    private static String dequote(String value) {
        Matcher matcher = QUOTED_PATTERN.matcher(value);
        String dequoted = matcher.matches() ? BACKQUOTE_PATTERN.matcher(matcher.group(1)).replaceAll("$1") : value;
        return dequoted;
    }

    @AutoValue
    static abstract class RegistrationInfo {
        RegistrationInfo() {
        }

        static RegistrationInfo registrationInfo(ReportedBean reportedBean, boolean applicationPrefix, String namePrefix, Map<String, String> tags) {
            return new AutoValue_ReportedBeanRegistry_RegistrationInfo(reportedBean, applicationPrefix, namePrefix, (Map<String, String>)ImmutableMap.copyOf(tags));
        }

        abstract ReportedBean getReportedBean();

        abstract boolean isApplicationPrefix();

        abstract String getNamePrefix();

        abstract Map<String, String> getTags();
    }
}

