/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.proofpoint.reporting.AnnotationUtils;
import com.proofpoint.reporting.BooleanPrometheusBeanAttribute;
import com.proofpoint.reporting.BooleanReportedBeanAttribute;
import com.proofpoint.reporting.BucketIdProvider;
import com.proofpoint.reporting.FlattenPrometheusBeanAttribute;
import com.proofpoint.reporting.FlattenReportedBeanAttribute;
import com.proofpoint.reporting.NestedPrometheusBeanAttribute;
import com.proofpoint.reporting.NestedReportedBeanAttribute;
import com.proofpoint.reporting.ObjectPrometheusBeanAttribute;
import com.proofpoint.reporting.ObjectReportedBeanAttribute;
import com.proofpoint.reporting.PrometheusBeanAttribute;
import com.proofpoint.reporting.ReflectionUtils;
import com.proofpoint.reporting.ReportedBean;
import com.proofpoint.reporting.ReportedBeanAttribute;
import com.proofpoint.reporting.ReportedMethodInfo;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

class ReportedMethodInfoBuilder {
    private final BucketIdProvider bucketIdProvider;
    private Object target;
    private String name;
    private Method concreteGetter;
    private Method annotatedGetter;

    ReportedMethodInfoBuilder(BucketIdProvider bucketIdProvider) {
        this.bucketIdProvider = bucketIdProvider;
    }

    ReportedMethodInfoBuilder onInstance(Object target) {
        Objects.requireNonNull(target, "target is null");
        this.target = target;
        return this;
    }

    ReportedMethodInfoBuilder named(String name) {
        Objects.requireNonNull(name, "name is null");
        this.name = name;
        return this;
    }

    ReportedMethodInfoBuilder withConcreteGetter(Method concreteGetter) {
        Objects.requireNonNull(concreteGetter, "concreteGetter is null");
        Preconditions.checkArgument((boolean)ReflectionUtils.isValidGetter(concreteGetter), (Object)("Method is not a valid getter: " + concreteGetter));
        this.concreteGetter = concreteGetter;
        return this;
    }

    ReportedMethodInfoBuilder withAnnotatedGetter(Method annotatedGetter) {
        Objects.requireNonNull(annotatedGetter, "annotatedGetter is null");
        Preconditions.checkArgument((boolean)ReflectionUtils.isValidGetter(annotatedGetter), (Object)("Method is not a valid getter: " + annotatedGetter));
        this.annotatedGetter = annotatedGetter;
        return this;
    }

    ReportedMethodInfo build() {
        Preconditions.checkArgument((this.target != null ? 1 : 0) != 0, (Object)"JmxAttribute must have a target object");
        if (AnnotationUtils.isFlatten(this.annotatedGetter)) {
            Preconditions.checkArgument((this.concreteGetter != null ? 1 : 0) != 0, (Object)"Flattened JmxAttribute must have a concrete getter");
            Object value = null;
            try {
                value = this.concreteGetter.invoke(this.target, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null) {
                return ReportedMethodInfo.reportedMethodInfo((Collection<ReportedBeanAttribute>)ImmutableList.of(), (Collection<PrometheusBeanAttribute>)ImmutableList.of());
            }
            ReportedBean reportedBean = ReportedBean.forTarget(value, this.bucketIdProvider);
            List<ReportedBeanAttribute> attributes = reportedBean.getAttributes().stream().map(attribute -> new FlattenReportedBeanAttribute(this.concreteGetter, (ReportedBeanAttribute)attribute)).collect(Collectors.toList());
            List<PrometheusBeanAttribute> prometheusAttributes = reportedBean.getPrometheusAttributes().stream().map(attribute -> new FlattenPrometheusBeanAttribute(this.concreteGetter, (PrometheusBeanAttribute)attribute)).collect(Collectors.toList());
            return ReportedMethodInfo.reportedMethodInfo(attributes, prometheusAttributes);
        }
        if (AnnotationUtils.isNested(this.annotatedGetter)) {
            Preconditions.checkArgument((this.concreteGetter != null ? 1 : 0) != 0, (Object)"Nested JmxAttribute must have a concrete getter");
            Object value = null;
            try {
                value = this.concreteGetter.invoke(this.target, new Object[0]);
            }
            catch (Exception reportedBean) {
                // empty catch block
            }
            if (value == null) {
                return ReportedMethodInfo.reportedMethodInfo((Collection<ReportedBeanAttribute>)ImmutableList.of(), (Collection<PrometheusBeanAttribute>)ImmutableList.of());
            }
            ReportedBean reportedBean = ReportedBean.forTarget(value, this.bucketIdProvider);
            List<ReportedBeanAttribute> attributes = reportedBean.getAttributes().stream().map(attribute -> new NestedReportedBeanAttribute(this.name, this.concreteGetter, (ReportedBeanAttribute)attribute)).collect(Collectors.toList());
            List<PrometheusBeanAttribute> prometheusAttributes = reportedBean.getPrometheusAttributes().stream().map(attribute -> new NestedPrometheusBeanAttribute(this.name, this.concreteGetter, (PrometheusBeanAttribute)attribute)).collect(Collectors.toList());
            return ReportedMethodInfo.reportedMethodInfo(attributes, prometheusAttributes);
        }
        Preconditions.checkArgument((this.concreteGetter != null ? 1 : 0) != 0, (Object)"JmxAttribute must have a concrete getter");
        Class<?> attributeType = this.concreteGetter.getReturnType();
        if (Boolean.class.isAssignableFrom(attributeType) || attributeType == Boolean.TYPE) {
            return ReportedMethodInfo.reportedMethodInfo((Collection<ReportedBeanAttribute>)(AnnotationUtils.isReported(this.annotatedGetter) ? ImmutableList.of((Object)new BooleanReportedBeanAttribute(this.name, this.target, this.concreteGetter)) : ImmutableList.of()), (Collection<PrometheusBeanAttribute>)ImmutableList.of((Object)new BooleanPrometheusBeanAttribute(this.name, this.target, this.concreteGetter)));
        }
        return ReportedMethodInfo.reportedMethodInfo((Collection<ReportedBeanAttribute>)(AnnotationUtils.isReported(this.annotatedGetter) ? ImmutableList.of((Object)new ObjectReportedBeanAttribute(this.name, this.target, this.concreteGetter)) : ImmutableList.of()), (Collection<PrometheusBeanAttribute>)ImmutableList.of((Object)new ObjectPrometheusBeanAttribute(this.name, this.target, this.concreteGetter)));
    }
}

