/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;

final class Signature {
    private final String actionName;
    private final List<String> parameterTypes;

    public Signature(Method method) {
        this.actionName = method.getName();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Class<?> type : method.getParameterTypes()) {
            builder.add((Object)type.getName());
        }
        this.parameterTypes = builder.build();
    }

    public int hashCode() {
        return Objects.hash(this.actionName, this.parameterTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.actionName, other.actionName) && Objects.equals(this.parameterTypes, other.parameterTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.actionName).append('(');
        boolean first = true;
        for (String type : this.parameterTypes) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(type);
            first = false;
        }
        sb.append(')');
        return sb.toString();
    }
}

