/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.reporting.testing;

import com.google.common.base.Ticker;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import com.proofpoint.reporting.ReportCollectionFactory;
import com.proofpoint.reporting.ReportExporter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.mockito.Mockito;

public class TestingReportCollectionFactory
extends ReportCollectionFactory {
    private static final Method OBJECT_EQUALS_METHOD;
    private final InstanceMap argumentVerifierMap = new InstanceMap();
    private final InstanceMap superMap = new InstanceMap();
    private final NamedInstanceMap namedArgumentVerifierMap = new NamedInstanceMap();
    private final NamedInstanceMap namedSuperMap = new NamedInstanceMap();

    public TestingReportCollectionFactory() {
        super((ReportExporter)Mockito.mock(ReportExporter.class), new Ticker(){

            public long read() {
                return 0L;
            }
        });
    }

    @Override
    public <T> T createReportCollection(Class<T> aClass) {
        Objects.requireNonNull(aClass, "class is null");
        Object argumentVerifier = Mockito.mock(aClass);
        this.namedArgumentVerifierMap.put(null, aClass, argumentVerifier);
        T superCollection = super.createReportCollection(aClass);
        this.namedSuperMap.put(null, aClass, superCollection);
        Object reportCollection = Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{aClass}, new TestingInvocationHandler<Object>(argumentVerifier, superCollection));
        this.argumentVerifierMap.put(reportCollection, argumentVerifier);
        this.superMap.put(reportCollection, superCollection);
        return (T)reportCollection;
    }

    @Override
    public <T> T createReportCollection(Class<T> aClass, boolean applicationPrefix, @Nullable String namePrefix, Map<String, String> tags) {
        Objects.requireNonNull(aClass, "class is null");
        Objects.requireNonNull(tags, "tags is null");
        Object argumentVerifier = Mockito.mock(aClass);
        T superCollection = super.createReportCollection(aClass);
        Object reportCollection = Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{aClass}, new TestingInvocationHandler<Object>(argumentVerifier, superCollection));
        this.argumentVerifierMap.put(reportCollection, argumentVerifier);
        this.superMap.put(reportCollection, superCollection);
        return (T)reportCollection;
    }

    @Override
    @Deprecated
    public <T> T createReportCollection(Class<T> aClass, String name) {
        Objects.requireNonNull(aClass, "class is null");
        Objects.requireNonNull(name, "name is null");
        Object argumentVerifier = Mockito.mock(aClass);
        this.namedArgumentVerifierMap.put(name, aClass, argumentVerifier);
        T superCollection = super.createReportCollection(aClass);
        this.namedSuperMap.put(name, aClass, superCollection);
        return (T)Proxy.newProxyInstance(aClass.getClassLoader(), new Class[]{aClass}, new TestingInvocationHandler<Object>(argumentVerifier, superCollection));
    }

    public <T> T getArgumentVerifier(T testingReportCollection) {
        return this.argumentVerifierMap.get(testingReportCollection);
    }

    @Deprecated
    public <T> T getArgumentVerifier(Class<T> aClass) {
        return this.namedArgumentVerifierMap.get(null, aClass);
    }

    @Deprecated
    public <T> T getArgumentVerifier(Class<T> aClass, String name) {
        Objects.requireNonNull(name, "name is null");
        return this.namedArgumentVerifierMap.get(name, aClass);
    }

    public <T> T getReportCollection(T testingReportCollection) {
        return this.superMap.get(testingReportCollection);
    }

    @Deprecated
    public <T> T getReportCollection(Class<T> aClass) {
        return this.namedSuperMap.get(null, aClass);
    }

    @Deprecated
    public <T> T getReportCollection(Class<T> aClass, String name) {
        Objects.requireNonNull(name, "name is null");
        return this.namedSuperMap.get(name, aClass);
    }

    @Override
    protected Supplier<Object> getReturnValueSupplier(Method method) {
        Supplier<Object> superSupplier = super.getReturnValueSupplier(method);
        return () -> Mockito.spy(superSupplier.get());
    }

    static {
        try {
            OBJECT_EQUALS_METHOD = Object.class.getDeclaredMethod("equals", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class NamedInstanceMap {
        private final Map<Optional<String>, ClassToInstanceMap<Object>> nameMap = new HashMap<Optional<String>, ClassToInstanceMap<Object>>();

        private NamedInstanceMap() {
        }

        public synchronized <T> void put(@Nullable String name, Class<T> aClass, T value) {
            MutableClassToInstanceMap instanceMap = this.nameMap.get(Optional.ofNullable(name));
            if (instanceMap == null) {
                instanceMap = MutableClassToInstanceMap.create();
                this.nameMap.put(Optional.ofNullable(name), (ClassToInstanceMap<Object>)instanceMap);
            }
            if (instanceMap.putInstance(aClass, value) != null) {
                String message = "Duplicate ReportCollection for " + aClass.toString();
                if (name != null) {
                    message = message + " named " + name;
                }
                throw new Error(message);
            }
        }

        public synchronized <T> T get(@Nullable String name, Class<T> aClass) {
            ClassToInstanceMap<Object> instanceMap = this.nameMap.get(Optional.ofNullable(name));
            if (instanceMap == null) {
                return null;
            }
            return (T)instanceMap.get(aClass);
        }
    }

    private static class InstanceMap {
        private final Map<Object, Object> map = new IdentityHashMap<Object, Object>();

        private InstanceMap() {
        }

        public synchronized <T> void put(T key, T value) {
            this.map.put(key, value);
        }

        public synchronized <T> T get(T key) {
            return (T)this.map.get(key);
        }
    }

    private static class TestingInvocationHandler<T>
    implements InvocationHandler {
        private final T argumentVerifier;
        private final T superCollection;

        TestingInvocationHandler(T argumentVerifier, T superCollection) {
            this.argumentVerifier = argumentVerifier;
            this.superCollection = superCollection;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            method.invoke(this.argumentVerifier, args);
            if (OBJECT_EQUALS_METHOD.equals(method)) {
                return proxy == args[0];
            }
            return method.invoke(this.superCollection, args);
        }
    }
}

