/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.proofpoint.configuration.ConfigBinder;
import com.proofpoint.configuration.ConfigurationAwareModule;
import com.proofpoint.configuration.ConfigurationFactory;
import java.util.Objects;

public abstract class AbstractConfigurationAwareModule
implements ConfigurationAwareModule {
    private ConfigurationFactory configurationFactory;
    private Binder binder;

    @Override
    public synchronized void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = Objects.requireNonNull(configurationFactory, "configurationFactory is null");
    }

    public final synchronized void configure(Binder binder) {
        Preconditions.checkState((this.binder == null ? 1 : 0) != 0, (Object)"re-entry not allowed");
        this.binder = Objects.requireNonNull(binder, "binder is null");
        try {
            this.setup(binder);
        }
        finally {
            this.binder = null;
        }
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass) {
        ConfigBinder.bindConfig(this.binder).bind(configClass);
        return this.configurationFactory.build(configClass);
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass, String prefix) {
        ConfigBinder.bindConfig(this.binder).bind(configClass).prefixedWith(prefix);
        return this.configurationFactory.build(configClass, prefix);
    }

    protected synchronized void install(Module module) {
        if (module instanceof ConfigurationAwareModule) {
            ((ConfigurationAwareModule)module).setConfigurationFactory(this.configurationFactory);
        }
        this.binder.install(module);
    }

    protected abstract void setup(Binder var1);
}

