/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.annotations.Beta;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.proofpoint.configuration.AbstractConfigurationAwareModule;
import java.util.Objects;
import java.util.function.Predicate;

@Beta
public class ConditionalModule<T>
extends AbstractConfigurationAwareModule {
    private final Class<T> config;
    private final Predicate<T> predicate;
    private final Module module;

    public static <T> Module installModuleIf(Class<T> config, Predicate<T> predicate, Module module) {
        return new ConditionalModule<T>(config, predicate, module);
    }

    private ConditionalModule(Class<T> config, Predicate<T> predicate, Module module) {
        this.config = Objects.requireNonNull(config, "config is null");
        this.predicate = Objects.requireNonNull(predicate, "predicate is null");
        this.module = Objects.requireNonNull(module, "module is null");
    }

    @Override
    protected void setup(Binder binder) {
        T configuration = this.buildConfigObject(this.config);
        if (this.predicate.test(configuration)) {
            this.install(this.module);
        }
    }
}

