/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.proofpoint.configuration.ConfigurationProvider;
import java.lang.annotation.Annotation;
import java.util.Objects;

public final class ConfigBinder {
    private final Binder binder;

    private ConfigBinder(Binder binder) {
        this.binder = binder.skipSources(new Class[]{ConfigBinder.class});
    }

    public static ConfigBinder bindConfig(Binder binder) {
        return new ConfigBinder(binder);
    }

    public <T> AnnotatedConfigBindingBuilder<T> bind(Class<T> configClass) {
        ConfigurationProvider<T> configurationProvider = new ConfigurationProvider<T>(configClass);
        AnnotatedBindingBuilder builder = this.binder.bind(configClass);
        builder.toProvider(configurationProvider);
        return new AnnotatedConfigBindingBuilder(builder, configurationProvider);
    }

    public static class PrefixConfigBindingBuilder<T> {
        final ConfigurationProvider<T> configurationProvider;

        private PrefixConfigBindingBuilder(ConfigurationProvider<T> configurationProvider) {
            this.configurationProvider = configurationProvider;
        }

        public void prefixedWith(String prefix) {
            Objects.requireNonNull(prefix, "prefix is null");
            this.configurationProvider.setPrefix(prefix);
        }
    }

    public static final class AnnotatedConfigBindingBuilder<T>
    extends PrefixConfigBindingBuilder<T> {
        private final AnnotatedBindingBuilder<T> builder;

        private AnnotatedConfigBindingBuilder(AnnotatedBindingBuilder<T> builder, ConfigurationProvider<T> configurationProvider) {
            super(configurationProvider);
            this.builder = builder;
        }

        public PrefixConfigBindingBuilder annotatedWith(Class<? extends Annotation> annotationType) {
            Objects.requireNonNull(annotationType, "annotationType is null");
            this.builder.annotatedWith(annotationType);
            this.configurationProvider.setKey(Key.get(this.configurationProvider.getConfigClass(), annotationType));
            return this;
        }

        public PrefixConfigBindingBuilder annotatedWith(Annotation annotation) {
            Objects.requireNonNull(annotation, "annotation is null");
            this.builder.annotatedWith(annotation);
            this.configurationProvider.setKey(Key.get(this.configurationProvider.getConfigClass(), (Annotation)annotation));
            return this;
        }
    }
}

