/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.collect.ImmutableMap;
import com.google.inject.spi.Message;
import com.proofpoint.configuration.ConfigurationDefaultingModule;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.Problems;
import com.proofpoint.configuration.WarningsMonitor;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;

public final class ConfigurationFactoryBuilder {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Set<String> expectToUse = new HashSet<String>();
    private Problems.Monitor monitor = Problems.NULL_MONITOR;
    private final List<String> errors = new ArrayList<String>();
    private Map<String, String> applicationDefaults = ImmutableMap.of();
    private Map<String, String> moduleDefaults = ImmutableMap.of();
    private Map<String, ConfigurationDefaultingModule> moduleDefaultSource = ImmutableMap.of();

    public ConfigurationFactoryBuilder withFile(final @Nullable String path) throws IOException {
        if (path == null) {
            return this;
        }
        Properties properties = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                Object old = super.put(key, value);
                if (old != null) {
                    ConfigurationFactoryBuilder.this.errors.add(String.format("Duplicate configuration property '%s' in file %s", key, path));
                }
                return old;
            }
        };
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        this.mergeProperties(properties);
        this.expectToUse.addAll(properties.stringPropertyNames());
        return this;
    }

    public ConfigurationFactoryBuilder withSystemProperties() {
        this.mergeProperties(System.getProperties());
        return this;
    }

    public ConfigurationFactoryBuilder withRequiredProperties(Map<String, String> requiredConfigurationProperties) {
        this.properties.putAll(requiredConfigurationProperties);
        this.expectToUse.addAll(requiredConfigurationProperties.keySet());
        return this;
    }

    public ConfigurationFactoryBuilder withApplicationDefaults(Map<String, String> applicationDefaults) {
        this.applicationDefaults = ImmutableMap.copyOf(applicationDefaults);
        this.expectToUse.addAll(applicationDefaults.keySet());
        return this;
    }

    public ConfigurationFactoryBuilder withModuleDefaults(Map<String, String> moduleDefaults, Map<String, ConfigurationDefaultingModule> moduleDefaultSource) {
        this.moduleDefaults = ImmutableMap.copyOf(moduleDefaults);
        this.moduleDefaultSource = ImmutableMap.copyOf(moduleDefaultSource);
        this.expectToUse.addAll(moduleDefaults.keySet());
        return this;
    }

    public ConfigurationFactoryBuilder withMonitor(Problems.Monitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public ConfigurationFactoryBuilder withWarningsMonitor(final WarningsMonitor warningsMonitor) {
        this.monitor = new Problems.Monitor(){

            @Override
            public void onError(Message errorMessage) {
            }

            @Override
            public void onWarning(Message warningMessage) {
                warningsMonitor.onWarning(warningMessage.getMessage());
            }
        };
        return this;
    }

    public ConfigurationFactory build() {
        return new ConfigurationFactory(this.properties, this.applicationDefaults, this.moduleDefaults, this.moduleDefaultSource, this.expectToUse, this.errors, this.monitor);
    }

    private void mergeProperties(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.properties.put(entry.getKey().toString(), entry.getValue().toString());
        }
    }
}

