/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binding;
import com.google.inject.ConfigurationException;
import com.google.inject.Module;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Message;
import com.google.inject.spi.PrivateElements;
import com.google.inject.spi.ProviderInstanceBinding;
import com.proofpoint.configuration.ConfigurationAwareProvider;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ElementsIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Provider;

public class ConfigurationValidator {
    private final ConfigurationFactory configurationFactory;

    public ConfigurationValidator(ConfigurationFactory configurationFactory) {
        Objects.requireNonNull(configurationFactory, "configurationFactory is null");
        this.configurationFactory = configurationFactory;
    }

    public List<Message> validate(Module ... modules) {
        return this.validate((Iterable<? extends Module>)ImmutableList.copyOf((Object[])modules));
    }

    public List<Message> validate(final Iterable<? extends Module> modules) {
        Message message;
        final ArrayList<Message> messages = new ArrayList<Message>();
        for (String error : this.configurationFactory.getInitialErrors()) {
            message = new Message(error);
            messages.add(message);
            this.configurationFactory.getMonitor().onError(message);
        }
        for (Element element : new ElementsIterator(modules)) {
            element.acceptVisitor((ElementVisitor)new DefaultElementVisitor<Void>(){

                public <T> Void visit(Binding<T> binding) {
                    ProviderInstanceBinding providerInstanceBinding;
                    Provider provider;
                    if (binding instanceof ProviderInstanceBinding && (provider = (providerInstanceBinding = (ProviderInstanceBinding)binding).getUserSuppliedProvider()) instanceof ConfigurationAwareProvider) {
                        ConfigurationAwareProvider configurationProvider = (ConfigurationAwareProvider)provider;
                        configurationProvider.setConfigurationFactory(ConfigurationValidator.this.configurationFactory);
                        try {
                            configurationProvider.buildConfigObjects(modules);
                        }
                        catch (ConfigurationException e) {
                            for (Message message : e.getErrorMessages()) {
                                messages.add(new Message(Collections.singletonList(binding.getSource()), message.getMessage(), message.getCause()));
                            }
                        }
                    }
                    return null;
                }

                public Void visit(PrivateElements privateElements) {
                    for (Element element : privateElements.getElements()) {
                        element.acceptVisitor((ElementVisitor)this);
                    }
                    return null;
                }
            });
        }
        for (String unusedProperty : this.configurationFactory.getUnusedProperties()) {
            message = new Message(String.format("Configuration property '%s' was not used", unusedProperty));
            messages.add(message);
            this.configurationFactory.getMonitor().onError(message);
        }
        return messages;
    }
}

