/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.tracetoken;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.proofpoint.tracetoken.AutoValue_TraceTokenManager_TokenState;
import com.proofpoint.tracetoken.TraceToken;
import com.proofpoint.tracetoken.TraceTokenScope;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;

public final class TraceTokenManager {
    private static final ThreadLocal<TokenState> token = new ThreadLocal();

    private TraceTokenManager() {
    }

    public static TraceTokenScope registerRequestToken(@Nullable String tokenId) {
        if (tokenId == null) {
            return TraceTokenManager.registerTraceToken(null);
        }
        return TraceTokenManager.registerTraceToken(new TraceToken((Map<String, String>)ImmutableMap.of((Object)"id", (Object)tokenId)));
    }

    public static TraceTokenScope registerTraceToken(@Nullable TraceToken token) {
        TokenState oldTokenState = TraceTokenManager.token.get();
        String oldThreadName = oldTokenState == null ? Thread.currentThread().getName() : oldTokenState.getOldThreadName();
        if (token == null) {
            TraceTokenManager.token.set(null);
            Thread.currentThread().setName(oldThreadName);
        } else {
            TraceTokenManager.token.set(new AutoValue_TraceTokenManager_TokenState(token, oldThreadName));
            Thread.currentThread().setName(oldThreadName + " " + (Object)((Object)token));
        }
        if (oldTokenState == null) {
            return new TraceTokenScope(null);
        }
        return new TraceTokenScope(oldTokenState.getToken());
    }

    @Deprecated
    @Nullable
    public static String getCurrentRequestToken() {
        TokenState tokenState = token.get();
        if (tokenState == null) {
            return null;
        }
        return tokenState.getToken().toString();
    }

    @Nullable
    public static TraceToken getCurrentTraceToken() {
        TokenState tokenState = token.get();
        if (tokenState == null) {
            return null;
        }
        return tokenState.getToken();
    }

    public static String createAndRegisterNewRequestToken(String ... properties) {
        Preconditions.checkArgument((properties.length % 2 == 0 ? 1 : 0) != 0, (Object)"odd number of elements in properties");
        String newToken = UUID.randomUUID().toString();
        TraceTokenManager.registerRequestToken(newToken);
        if (properties.length != 0) {
            TraceTokenManager.addTraceTokenProperties(properties);
        }
        return newToken;
    }

    public static void clearRequestToken() {
        TokenState oldToken = token.get();
        token.remove();
        if (oldToken != null) {
            Thread.currentThread().setName(oldToken.getOldThreadName());
        }
    }

    public static TraceTokenScope addTraceTokenProperties(String ... properties) {
        TokenState tokenState = token.get();
        if (tokenState == null) {
            return new TraceTokenScope(null);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>((Map<String, String>)((Object)tokenState.getToken()));
        Preconditions.checkArgument((properties.length % 2 == 0 ? 1 : 0) != 0, (Object)"odd number of elements in properties");
        for (int i = 0; i < properties.length; i += 2) {
            Objects.requireNonNull(properties[i], "property key is null");
            Objects.requireNonNull(properties[i + 1], "property value is null");
            map.put(properties[i], properties[i + 1]);
        }
        return TraceTokenManager.registerTraceToken(new TraceToken(map));
    }

    @AutoValue
    static abstract class TokenState {
        TokenState() {
        }

        abstract TraceToken getToken();

        abstract String getOldThreadName();
    }
}

