/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.proofpoint.reporting.Prometheus;
import com.proofpoint.reporting.PrometheusType;
import com.proofpoint.stats.BucketedCounter;
import com.proofpoint.stats.DecayCounter;
import com.proofpoint.stats.ExponentialDecay;
import java.util.concurrent.atomic.AtomicLong;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@Beta
public class CounterStat {
    private final AtomicLong count = new AtomicLong(0L);
    private final DecayCounter oneMinute = new DecayCounter(ExponentialDecay.oneMinute());
    private final DecayCounter fiveMinute = new DecayCounter(ExponentialDecay.fiveMinutes());
    private final DecayCounter fifteenMinute = new DecayCounter(ExponentialDecay.fifteenMinutes());
    private final BucketedCounter bucket = new BucketedCounter();

    public void add(long count) {
        this.oneMinute.add(count);
        this.fiveMinute.add(count);
        this.fifteenMinute.add(count);
        this.bucket.add(count);
        this.count.addAndGet(count);
    }

    @Deprecated
    public void update(long count) {
        this.oneMinute.add(count);
        this.fiveMinute.add(count);
        this.fifteenMinute.add(count);
        this.bucket.add(count);
        this.count.addAndGet(count);
    }

    public void merge(CounterStat counterStat) {
        Preconditions.checkNotNull((Object)counterStat, (Object)"counterStat is null");
        this.oneMinute.merge(counterStat.getOneMinute());
        this.fiveMinute.merge(counterStat.getFiveMinute());
        this.fifteenMinute.merge(counterStat.getFifteenMinute());
        this.count.addAndGet(counterStat.getTotalCount());
    }

    @Managed
    public void reset() {
        this.oneMinute.reset();
        this.fiveMinute.reset();
        this.fifteenMinute.reset();
        this.count.set(0L);
    }

    @Deprecated
    public void resetTo(CounterStat counterStat) {
        this.oneMinute.resetTo(counterStat.getOneMinute());
        this.fiveMinute.resetTo(counterStat.getFiveMinute());
        this.fifteenMinute.resetTo(counterStat.getFifteenMinute());
        this.count.set(counterStat.getTotalCount());
    }

    @Managed
    @Prometheus(name="Count", type=PrometheusType.COUNTER)
    public long getTotalCount() {
        return this.count.get();
    }

    @Nested
    public DecayCounter getOneMinute() {
        return this.oneMinute;
    }

    @Nested
    public DecayCounter getFiveMinute() {
        return this.fiveMinute;
    }

    @Nested
    public DecayCounter getFifteenMinute() {
        return this.fifteenMinute;
    }

    @Flatten
    public BucketedCounter getBucket() {
        return this.bucket;
    }

    public CounterStatSnapshot snapshot() {
        return new CounterStatSnapshot(this.getTotalCount(), this.getOneMinute().snapshot(), this.getFiveMinute().snapshot(), this.getFifteenMinute().snapshot());
    }

    public static class CounterStatSnapshot {
        private final long totalCount;
        private final DecayCounter.DecayCounterSnapshot oneMinute;
        private final DecayCounter.DecayCounterSnapshot fiveMinute;
        private final DecayCounter.DecayCounterSnapshot fifteenMinute;

        @JsonCreator
        public CounterStatSnapshot(@JsonProperty(value="totalCount") long totalCount, @JsonProperty(value="oneMinute") DecayCounter.DecayCounterSnapshot oneMinute, @JsonProperty(value="fiveMinute") DecayCounter.DecayCounterSnapshot fiveMinute, @JsonProperty(value="fifteenMinute") DecayCounter.DecayCounterSnapshot fifteenMinute) {
            this.totalCount = totalCount;
            this.oneMinute = oneMinute;
            this.fiveMinute = fiveMinute;
            this.fifteenMinute = fifteenMinute;
        }

        @JsonProperty
        public long getTotalCount() {
            return this.totalCount;
        }

        @JsonProperty
        public DecayCounter.DecayCounterSnapshot getOneMinute() {
            return this.oneMinute;
        }

        @JsonProperty
        public DecayCounter.DecayCounterSnapshot getFiveMinute() {
            return this.fiveMinute;
        }

        @JsonProperty
        public DecayCounter.DecayCounterSnapshot getFifteenMinute() {
            return this.fifteenMinute;
        }
    }
}

