/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.proofpoint.reporting.Bucketed;
import com.proofpoint.reporting.Reported;
import java.util.concurrent.atomic.AtomicLong;

public class MaxGauge
extends Bucketed<Bucket> {
    AtomicLong currentValue = new AtomicLong();

    public void update(long value) {
        this.currentValue.set(value);
        this.applyToCurrentBucket(bucket -> bucket.maxValue.accumulateAndGet(value, Long::max));
    }

    public void updateInstantaneous(long value) {
        this.applyToCurrentBucket(bucket -> bucket.maxValue.accumulateAndGet(value, Long::max));
    }

    public void add(int delta) {
        long value = this.currentValue.addAndGet(delta);
        if (delta > 0) {
            this.applyToCurrentBucket(bucket -> bucket.maxValue.accumulateAndGet(value, Long::max));
        }
    }

    public long get() {
        return this.currentValue.get();
    }

    protected Bucket createBucket(Bucket previousBucket) {
        return new Bucket(this.currentValue.get());
    }

    static class Bucket {
        AtomicLong maxValue;

        Bucket(long value) {
            this.maxValue = new AtomicLong(value);
        }

        @Reported
        public long getMax() {
            return this.maxValue.get();
        }
    }
}

