/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.google.common.util.concurrent.AtomicDouble;
import com.proofpoint.reporting.Bucketed;
import com.proofpoint.reporting.Prometheus;
import com.proofpoint.reporting.PrometheusType;
import com.proofpoint.reporting.Reported;

public class SparseCounterStat
extends Bucketed<Counter> {
    private final AtomicDouble count = new AtomicDouble(0.0);

    public void add(long count) {
        this.addInternal(count);
    }

    public void add(double count) {
        this.addInternal(count);
    }

    private void addInternal(double count) {
        this.count.addAndGet(count);
        this.applyToCurrentBucket(input -> {
            Counter counter = input;
            counter.count = counter.count + count;
            return null;
        });
    }

    @Prometheus(name="Count", type=PrometheusType.COUNTER)
    public double getTotalCount() {
        return this.count.get();
    }

    protected final Counter createBucket(Counter previousBucket) {
        return new Counter();
    }

    protected static class Counter {
        private double count = 0.0;

        protected Counter() {
        }

        @Reported
        @Prometheus(type=PrometheusType.SUPPRESSED)
        public Double getCount() {
            if (this.count == 0.0) {
                return null;
            }
            return this.count;
        }
    }
}

