/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.proofpoint.reporting.Prometheus;
import com.proofpoint.reporting.PrometheusSummary;
import com.proofpoint.reporting.PrometheusType;
import com.proofpoint.reporting.Reported;
import com.proofpoint.stats.QuantileDigest;
import com.proofpoint.units.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

public class SparseTimeStat
extends PrometheusSummary<Distribution> {
    private final Ticker ticker;

    public SparseTimeStat() {
        this(Ticker.systemTicker());
    }

    public SparseTimeStat(Ticker ticker) {
        this.ticker = ticker;
    }

    public void add(long value, TimeUnit timeUnit) {
        this.add(timeUnit.toNanos(value));
    }

    public void add(double value, TimeUnit timeUnit) {
        this.add(new Duration(value, timeUnit).roundTo(TimeUnit.NANOSECONDS));
    }

    public void add(Duration duration) {
        this.add(duration.roundTo(TimeUnit.NANOSECONDS));
    }

    private void add(long value) {
        this.applyToCurrentBucket(input -> {
            Distribution distribution = input;
            synchronized (distribution) {
                ((Distribution)input).allTimeCount++;
                Distribution distribution2 = input;
                distribution2.allTimeTotal = distribution2.allTimeTotal + value;
                ((Distribution)input).digest.add(value);
                distribution2 = input;
                distribution2.total = distribution2.total + value;
            }
            return null;
        });
    }

    public <T> T time(Callable<T> callable) throws Exception {
        try (BlockTimer ignored = this.time();){
            T t = callable.call();
            return t;
        }
    }

    public BlockTimer time() {
        return new BlockTimer(this);
    }

    protected final Distribution createBucket(Distribution previousBucket) {
        return new Distribution(previousBucket);
    }

    protected static class Distribution {
        private static final double MAX_ERROR = 0.01;
        @GuardedBy(value="this")
        private long allTimeTotal = 0L;
        @GuardedBy(value="this")
        private long allTimeCount = 0L;
        @GuardedBy(value="this")
        private final QuantileDigest digest = new QuantileDigest(0.01);
        @GuardedBy(value="this")
        private long total = 0L;

        public Distribution(Distribution previousDistribution) {
            if (previousDistribution != null) {
                this.allTimeTotal = previousDistribution.allTimeTotal;
                this.allTimeCount = previousDistribution.allTimeCount;
            }
        }

        @Prometheus(name="Sum", type=PrometheusType.COUNTER)
        public synchronized double getAllTimeTotal() {
            return Distribution.convertToSeconds(this.allTimeTotal);
        }

        @Prometheus(name="Count", type=PrometheusType.COUNTER)
        public synchronized long getAllTimeCount() {
            return this.allTimeCount;
        }

        @Reported
        @Prometheus(type=PrometheusType.SUPPRESSED)
        public synchronized double getCount() {
            double count = this.digest.getCount();
            if (count == 0.0) {
                return Double.NaN;
            }
            return count;
        }

        @Reported
        @Prometheus(type=PrometheusType.SUPPRESSED)
        public synchronized double getTotal() {
            if (this.digest.getCount() == 0.0) {
                return Double.NaN;
            }
            return Distribution.convertToSeconds(this.total);
        }

        @Reported
        public synchronized double getP50() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.5));
        }

        @Reported
        public synchronized double getP75() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.75));
        }

        @Reported
        public synchronized double getP90() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.9));
        }

        @Reported
        public synchronized double getP95() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.95));
        }

        @Reported
        public synchronized double getP99() {
            return Distribution.convertToSeconds(this.digest.getQuantile(0.99));
        }

        @Reported
        public synchronized double getMin() {
            return Distribution.convertToSeconds(this.digest.getMin());
        }

        @Reported
        public synchronized double getMax() {
            return Distribution.convertToSeconds(this.digest.getMax());
        }

        private static double convertToSeconds(long nanos) {
            if (nanos == Long.MAX_VALUE || nanos == Long.MIN_VALUE) {
                return Double.NaN;
            }
            return (double)nanos * 1.0E-9;
        }
    }

    public static class BlockTimer
    implements AutoCloseable {
        private final long start;
        private SparseTimeStat sparseTimeStat;

        public BlockTimer(SparseTimeStat sparseTimeStat) {
            this.sparseTimeStat = sparseTimeStat;
            this.start = sparseTimeStat.ticker.read();
        }

        public void timeTo(SparseTimeStat sparseTimeStat) {
            Preconditions.checkArgument((sparseTimeStat.ticker == this.sparseTimeStat.ticker ? 1 : 0) != 0, (Object)"sparseTimeStat uses the same ticker");
            this.sparseTimeStat = sparseTimeStat;
        }

        @Override
        public void close() {
            this.sparseTimeStat.add(this.sparseTimeStat.ticker.read() - this.start);
        }
    }
}

