/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.proofpoint.stats.BucketedTimeDistribution;
import com.proofpoint.stats.ExponentialDecay;
import com.proofpoint.stats.TimeDistribution;
import com.proofpoint.units.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Nested;

public class TimeStat {
    private final TimeDistribution oneMinute;
    private final TimeDistribution fiveMinutes;
    private final TimeDistribution fifteenMinutes;
    private final TimeDistribution allTime;
    private final BucketedTimeDistribution bucket = new BucketedTimeDistribution();
    private final Ticker ticker;

    public TimeStat() {
        this(Ticker.systemTicker());
    }

    public TimeStat(Ticker ticker) {
        this.ticker = ticker;
        this.oneMinute = new TimeDistribution(ExponentialDecay.oneMinute());
        this.fiveMinutes = new TimeDistribution(ExponentialDecay.fiveMinutes());
        this.fifteenMinutes = new TimeDistribution(ExponentialDecay.fifteenMinutes());
        this.allTime = new TimeDistribution();
    }

    public void add(long value, TimeUnit timeUnit) {
        this.add(timeUnit.toNanos(value));
    }

    public void add(double value, TimeUnit timeUnit) {
        this.add(new Duration(value, timeUnit).roundTo(TimeUnit.NANOSECONDS));
    }

    public void add(Duration duration) {
        this.add(duration.roundTo(TimeUnit.NANOSECONDS));
    }

    private void add(long value) {
        this.oneMinute.add(value);
        this.fiveMinutes.add(value);
        this.fifteenMinutes.add(value);
        this.allTime.add(value);
        this.bucket.add(value);
    }

    public <T> T time(Callable<T> callable) throws Exception {
        try (BlockTimer ignored = this.time();){
            T t = callable.call();
            return t;
        }
    }

    public BlockTimer time() {
        return new BlockTimer(this);
    }

    @Nested
    public TimeDistribution getOneMinute() {
        return this.oneMinute;
    }

    @Nested
    public TimeDistribution getFiveMinutes() {
        return this.fiveMinutes;
    }

    @Nested
    public TimeDistribution getFifteenMinutes() {
        return this.fifteenMinutes;
    }

    @Nested
    public TimeDistribution getAllTime() {
        return this.allTime;
    }

    @Flatten
    public BucketedTimeDistribution getBucket() {
        return this.bucket;
    }

    public TimeDistributionStatSnapshot snapshot() {
        return new TimeDistributionStatSnapshot(this.getOneMinute().snapshot(), this.getFiveMinutes().snapshot(), this.getFifteenMinutes().snapshot(), this.getAllTime().snapshot());
    }

    public static class TimeDistributionStatSnapshot {
        private final TimeDistribution.TimeDistributionSnapshot oneMinute;
        private final TimeDistribution.TimeDistributionSnapshot fiveMinute;
        private final TimeDistribution.TimeDistributionSnapshot fifteenMinute;
        private final TimeDistribution.TimeDistributionSnapshot allTime;

        @JsonCreator
        public TimeDistributionStatSnapshot(@JsonProperty(value="oneMinute") TimeDistribution.TimeDistributionSnapshot oneMinute, @JsonProperty(value="fiveMinute") TimeDistribution.TimeDistributionSnapshot fiveMinute, @JsonProperty(value="fifteenMinute") TimeDistribution.TimeDistributionSnapshot fifteenMinute, @JsonProperty(value="allTime") TimeDistribution.TimeDistributionSnapshot allTime) {
            this.oneMinute = oneMinute;
            this.fiveMinute = fiveMinute;
            this.fifteenMinute = fifteenMinute;
            this.allTime = allTime;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getOneMinute() {
            return this.oneMinute;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getFiveMinutes() {
            return this.fiveMinute;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getFifteenMinutes() {
            return this.fifteenMinute;
        }

        @JsonProperty
        public TimeDistribution.TimeDistributionSnapshot getAllTime() {
            return this.allTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("oneMinute", (Object)this.oneMinute).add("fiveMinute", (Object)this.fiveMinute).add("fifteenMinute", (Object)this.fifteenMinute).add("allTime", (Object)this.allTime).toString();
        }
    }

    public static class BlockTimer
    implements AutoCloseable {
        private final long start;
        private TimeStat timeStat;

        public BlockTimer(TimeStat timeStat) {
            this.timeStat = timeStat;
            this.start = timeStat.ticker.read();
        }

        public void timeTo(TimeStat timeStat) {
            Preconditions.checkArgument((timeStat.ticker == this.timeStat.ticker ? 1 : 0) != 0, (Object)"timeStat uses the same ticker");
            this.timeStat = timeStat;
        }

        @Override
        public void close() {
            this.timeStat.add(this.timeStat.ticker.read() - this.start);
        }
    }
}

