/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.testing;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Longs;
import com.google.common.util.concurrent.Futures;
import com.proofpoint.testing.TestingTicker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class SerialScheduledExecutorService
implements ScheduledExecutorService {
    private final TestingTicker ticker = new TestingTicker();
    private final PriorityQueue<SerialScheduledFuture<?>> futureTasks = new PriorityQueue();
    private Collection<SerialScheduledFuture<?>> tasks = this.futureTasks;
    private boolean isShutdown = false;

    @Override
    public void execute(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable, (Object)"Task object is null");
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.isShutdown();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return true;
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        Preconditions.checkNotNull(tCallable, (Object)"Task object is null");
        try {
            return Futures.immediateFuture(tCallable.call());
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        Preconditions.checkNotNull((Object)runnable, (Object)"Task object is null");
        try {
            runnable.run();
            return Futures.immediateFuture(t);
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        Preconditions.checkNotNull((Object)runnable, (Object)"Task object is null");
        return this.submit(runnable, null);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        Preconditions.checkNotNull(callables, (Object)"Task object list is null");
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (Callable<T> callable : callables) {
            try {
                resultBuilder.add((Object)Futures.immediateFuture(callable.call()));
            }
            catch (Exception e) {
                resultBuilder.add((Object)Futures.immediateFailedFuture((Throwable)e));
            }
        }
        return resultBuilder.build();
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        Preconditions.checkNotNull(callables, (Object)"Task object list is null");
        return this.invokeAll(callables);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        Preconditions.checkNotNull(callables, (Object)"callables is null");
        Preconditions.checkArgument((!callables.isEmpty() ? 1 : 0) != 0, (Object)"callables is empty");
        try {
            return callables.iterator().next().call();
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.invokeAny(callables);
    }

    public void elapseTime(long quantum, TimeUnit timeUnit) {
        Preconditions.checkArgument((quantum > 0L ? 1 : 0) != 0, (Object)"Time quantum must be a positive number");
        Preconditions.checkState((!this.isShutdown ? 1 : 0) != 0, (Object)"Trying to elapse time after shutdown");
        this.elapseTime(SerialScheduledExecutorService.toNanos(quantum, timeUnit), this.ticker);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)runnable, (Object)"Task object is null");
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Delay must not be negative");
        SerialScheduledFuture<Object> future = new SerialScheduledFuture<Object>(new FutureTask<Object>(runnable, null), SerialScheduledExecutorService.toNanos(l, timeUnit));
        if (l == 0L) {
            future.task.run();
        } else {
            this.tasks.add(future);
        }
        return future;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> vCallable, long l, TimeUnit timeUnit) {
        Preconditions.checkNotNull(vCallable, (Object)"Task object is null");
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (Object)"Delay must not be negative");
        SerialScheduledFuture<V> future = new SerialScheduledFuture<V>(new FutureTask<V>(vCallable), SerialScheduledExecutorService.toNanos(l, timeUnit));
        if (l == 0L) {
            future.task.run();
        } else {
            this.tasks.add(future);
        }
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        Preconditions.checkNotNull((Object)runnable, (Object)"Task object is null");
        Preconditions.checkArgument((initialDelay >= 0L ? 1 : 0) != 0, (Object)"Initial delay must not be negative");
        Preconditions.checkArgument((period > 0L ? 1 : 0) != 0, (Object)"Repeating delay must be greater than 0");
        RecurringRunnableSerialScheduledFuture future = new RecurringRunnableSerialScheduledFuture(runnable, SerialScheduledExecutorService.toNanos(initialDelay, timeUnit), SerialScheduledExecutorService.toNanos(period, timeUnit));
        if (initialDelay == 0L) {
            future.task.run();
            if (future.isFailed()) {
                return future;
            }
            ((SerialScheduledFuture)future).restartDelayTimer();
        }
        this.tasks.add(future);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        return this.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void elapseTime(long quantum, @Nullable TestingTicker ticker) {
        ArrayList toRequeue = Lists.newArrayList();
        Collection<SerialScheduledFuture<?>> originalTasks = this.tasks;
        this.tasks = Lists.newArrayList();
        try {
            SerialScheduledFuture<?> current;
            while ((current = this.futureTasks.poll()) != null) {
                if (current.isCancelled()) continue;
                if (current.isDone()) {
                    throw new AssertionError((Object)"Found a done task in the queue (contrary to expectation)");
                }
                long used = current.elapseTime(quantum, ticker);
                if (!current.isDone()) {
                    toRequeue.add(current);
                    continue;
                }
                if (used < quantum) {
                    this.elapseTime(used, (TestingTicker)null);
                    SerialScheduledExecutorService.rescheduleTaskIfRequired(this.futureTasks, current);
                    this.futureTasks.addAll(this.tasks);
                    this.tasks.clear();
                    quantum -= used;
                    continue;
                }
                ticker = null;
                SerialScheduledExecutorService.rescheduleTaskIfRequired(toRequeue, current);
            }
            if (ticker != null) {
                ticker.increment(quantum, TimeUnit.NANOSECONDS);
            }
        }
        finally {
            this.futureTasks.addAll(toRequeue);
            this.futureTasks.addAll(this.tasks);
            this.tasks.clear();
            this.tasks = originalTasks;
        }
    }

    private static void rescheduleTaskIfRequired(Collection<SerialScheduledFuture<?>> tasks, SerialScheduledFuture<?> task) {
        if (task.isRecurring() && !task.isFailed()) {
            task.restartDelayTimer();
            tasks.add(task);
        }
    }

    private static long toNanos(long quantum, TimeUnit timeUnit) {
        return TimeUnit.NANOSECONDS.convert(quantum, timeUnit);
    }

    class RecurringRunnableSerialScheduledFuture
    extends SerialScheduledFuture<Void> {
        private final long recurringDelayNanos;
        private final Runnable runnable;

        RecurringRunnableSerialScheduledFuture(Runnable runnable, long initialDelayNanos, long recurringDelayNanos) {
            super(new FutureTask<Object>(runnable, null), initialDelayNanos);
            this.runnable = runnable;
            this.recurringDelayNanos = recurringDelayNanos;
        }

        @Override
        public boolean isRecurring() {
            return true;
        }

        @Override
        public void restartDelayTimer() {
            this.task = new FutureTask<Object>(this.runnable, null);
            this.remainingDelayNanos = this.recurringDelayNanos;
        }
    }

    class SerialScheduledFuture<T>
    implements ScheduledFuture<T> {
        long remainingDelayNanos;
        FutureTask<T> task;

        SerialScheduledFuture(FutureTask<T> task, long delayNanos) {
            this.task = task;
            this.remainingDelayNanos = delayNanos;
        }

        long elapseTime(long quantumNanos, @Nullable TestingTicker ticker) {
            if (this.task.isDone() || this.task.isCancelled()) {
                return 0L;
            }
            if (this.remainingDelayNanos <= quantumNanos) {
                if (ticker != null) {
                    ticker.increment(this.remainingDelayNanos, TimeUnit.NANOSECONDS);
                }
                this.task.run();
                return this.remainingDelayNanos;
            }
            this.remainingDelayNanos -= quantumNanos;
            return quantumNanos;
        }

        public boolean isRecurring() {
            return false;
        }

        public void restartDelayTimer() {
            throw new UnsupportedOperationException("Can't restart a non-recurring task");
        }

        @Override
        public long getDelay(TimeUnit timeUnit) {
            return timeUnit.convert(this.remainingDelayNanos, TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (delayed instanceof SerialScheduledFuture) {
                SerialScheduledFuture other = (SerialScheduledFuture)delayed;
                return Longs.compare((long)this.remainingDelayNanos, (long)other.remainingDelayNanos);
            }
            return Longs.compare((long)this.remainingDelayNanos, (long)delayed.getDelay(TimeUnit.NANOSECONDS));
        }

        @Override
        public boolean cancel(boolean b) {
            return this.task.cancel(b);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone() || this.task.isCancelled();
        }

        public boolean isFailed() {
            if (!this.isDone()) {
                return false;
            }
            try {
                this.task.get();
            }
            catch (Throwable ignored) {
                return true;
            }
            return false;
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            if (this.isCancelled()) {
                throw new CancellationException();
            }
            if (!this.isDone()) {
                throw new IllegalStateException("Called get() before result was available in SerialScheduledFuture");
            }
            return this.task.get();
        }

        @Override
        public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }
}

