/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.testing;

import com.google.common.annotations.Beta;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.testng.Assert;

@Beta
public class ValidationAssertions {
    private static final Validator VALIDATOR = ((ApacheValidatorConfiguration)Validation.byProvider(ApacheValidationProvider.class).configure()).buildValidatorFactory().getValidator();

    public static <T> T assertValidates(T object) {
        return ValidationAssertions.assertValidates(object, null);
    }

    public static <T> T assertValidates(T object, String message) {
        Set violations = VALIDATOR.validate(object, new Class[0]);
        if (violations.isEmpty()) {
            return object;
        }
        StringBuilder builder = new StringBuilder(ValidationAssertions.toMessageString(message));
        builder.append("expected:<").append(object).append("> to pass validation:");
        ValidationAssertions.appendViolations(builder, violations);
        Assert.fail((String)builder.toString());
        return object;
    }

    private static <T> void appendViolations(StringBuilder builder, Set<ConstraintViolation<T>> violations) {
        for (ConstraintViolation<T> violation : violations) {
            builder.append("\n\t").append(violation.getPropertyPath().toString()).append(" failed validation for ").append(violation.getConstraintDescriptor().getAnnotation().annotationType().getName()).append(" with message '").append(violation.getMessage()).append("'");
        }
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation, String message) {
        Set violations = VALIDATOR.validate(object, new Class[0]);
        for (ConstraintViolation violation : violations) {
            if (!annotation.isInstance(violation.getConstraintDescriptor().getAnnotation()) || !violation.getPropertyPath().toString().equals(field)) continue;
            if (!violation.getMessage().equals(expectedErrorMessage)) {
                Assert.fail((String)String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s', but message was '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, message, annotation.getName(), expectedErrorMessage, violation.getMessage()));
            }
            return;
        }
        StringBuilder builder = new StringBuilder(String.format("%sexpected %s.%s for <%s> to fail validation for %s with message '%s'", ValidationAssertions.toMessageString(message), object.getClass().getName(), field, object, annotation.getName(), expectedErrorMessage));
        if (violations.isEmpty()) {
            builder.append(" but it passed");
        } else {
            builder.append(" but it failed for other fields:");
            ValidationAssertions.appendViolations(builder, violations);
        }
        Assert.fail((String)builder.toString());
    }

    public static <T> void assertFailsValidation(T object, String field, String expectedErrorMessage, Class<? extends Annotation> annotation) {
        ValidationAssertions.assertFailsValidation(object, field, expectedErrorMessage, annotation, null);
    }

    private static String toMessageString(String message) {
        return message == null ? "" : message + " ";
    }
}

