/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.tracetoken;

import com.proofpoint.log.Logging;
import java.util.UUID;

public final class TraceTokenManager {
    private static final String TRACE_TOKEN = "TraceToken";
    private final ThreadLocal<String> token = new ThreadLocal();

    public void registerRequestToken(String token) {
        this.token.set(token);
        Logging.putMDC((String)TRACE_TOKEN, (Object)token);
    }

    public String getCurrentRequestToken() {
        return this.token.get();
    }

    public String createAndRegisterNewRequestToken() {
        String newToken = UUID.randomUUID().toString();
        this.registerRequestToken(newToken);
        return newToken;
    }

    public void clearRequestToken() {
        this.token.remove();
        Logging.removeMDC((String)TRACE_TOKEN);
    }
}

