/*
 * Decompiled with CFR 0.152.
 */
package rapture.http;

import java.nio.ByteBuffer;
import rapture.codec.Encoding;
import rapture.codec.encodings$;
import rapture.core.Mode;
import rapture.core.Mode$;
import rapture.dom.DomFormatter;
import rapture.fs.FsUrl;
import rapture.html.HtmlDoc;
import rapture.http.Attachment;
import rapture.http.BufferResponse;
import rapture.http.ByteStreamResponse;
import rapture.http.Cached;
import rapture.http.ErrorResponse;
import rapture.http.FileResponse;
import rapture.http.HttpHandler;
import rapture.http.HttpHandler$;
import rapture.http.HttpHandler$class;
import rapture.http.HttpHandler_1;
import rapture.http.HttpHandler_1$class;
import rapture.http.RedirectResponse;
import rapture.http.Response;
import rapture.http.Response$;
import rapture.http.StreamResponse;
import rapture.io.Input;
import rapture.io.Output;
import rapture.io.Reader$;
import rapture.io.package$;
import rapture.json.Json;
import rapture.mime.MimeTypes;
import rapture.mime.MimeTypes$;
import rapture.time.DateFormat;
import rapture.time.TimeFormat;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.xml.Node;

public final class HttpHandler$
implements HttpHandler_1 {
    public static final HttpHandler$ MODULE$;
    private final Object StringInputHandler;
    private final Object nullHandler;
    private final Object linkRedirectHandler;

    static {
        new HttpHandler$();
    }

    @Override
    public Object linkRedirectHandler() {
        return this.linkRedirectHandler;
    }

    @Override
    public void rapture$http$HttpHandler_1$_setter_$linkRedirectHandler_$eq(HttpHandler x$1) {
        this.linkRedirectHandler = x$1;
    }

    public Object charInputHandler(Encoding enc, MimeTypes.MimeType mimeType) {
        return new HttpHandler<Input<Object>>(enc, mimeType){
            private final Encoding enc$1;
            private final MimeTypes.MimeType mimeType$1;

            public <S> HttpHandler<S> contraMap(Function1<S, Input<Object>> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public StreamResponse response(Input<Object> in) {
                return new StreamResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), this.mimeType$1, (Function1<Output<Object>, BoxedUnit>)new Serializable(this, in){
                    public static final long serialVersionUID = 0L;
                    private final Input in$2;

                    public final void apply(Output<Object> os) {
                        package$.MODULE$.readable((Object)this.in$2).$greater(os, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        os.close();
                    }
                    {
                        this.in$2 = in$2;
                    }
                }, this.enc$1);
            }
            {
                this.enc$1 = enc$1;
                this.mimeType$1 = mimeType$1;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public Object StringInputHandler() {
        return this.StringInputHandler;
    }

    public Object xmlHandler(Encoding enc) {
        return new HttpHandler<Seq<Node>>(enc){
            public final Encoding enc$2;

            public <S> HttpHandler<S> contraMap(Function1<S, Seq<Node>> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public StreamResponse response(Seq<Node> t) {
                return new StreamResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), MimeTypes$.MODULE$.application$divxml(), (Function1<Output<Object>, BoxedUnit>)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.7 $outer;
                    private final Seq t$1;

                    public final void apply(Output<Object> os) {
                        package$.MODULE$.readable(package$.MODULE$.readable((Object)new StringBuilder().append((Object)"<?xml version=\"1.0\" encoding=\"").append((Object)this.$outer.enc$2.name()).append((Object)"\"?>\n").toString()).input(Reader$.MODULE$.stringCharReader(), (Mode)Mode$.MODULE$.defaultMode())).$greater(os, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        package$.MODULE$.readable(package$.MODULE$.readable((Object)this.t$1.toString()).input(Reader$.MODULE$.stringCharReader(), (Mode)Mode$.MODULE$.defaultMode())).$greater(os, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        os.close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.t$1 = t$1;
                    }
                }, this.enc$2);
            }
            {
                this.enc$2 = enc$2;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public HttpHandler<HtmlDoc> htmlDocHandler(DomFormatter<String> f) {
        return new HttpHandler<HtmlDoc>(f){
            public final DomFormatter f$1;

            public <S> HttpHandler<S> contraMap(Function1<S, HtmlDoc> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public StreamResponse response(HtmlDoc htmlDoc) {
                return new StreamResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), MimeTypes$.MODULE$.text$divhtml(), (Function1<Output<Object>, BoxedUnit>)new Serializable(this, htmlDoc){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anon.8 $outer;
                    private final HtmlDoc htmlDoc$1;

                    public final void apply(Output<Object> out) {
                        package$.MODULE$.readable(package$.MODULE$.readable((Object)new StringBuilder().append((Object)this.htmlDoc$1.doctype().toString()).append((Object)"\n").toString()).input(Reader$.MODULE$.stringCharReader(), (Mode)Mode$.MODULE$.defaultMode())).$greater(out, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        package$.MODULE$.readable(package$.MODULE$.readable(this.htmlDoc$1.html().format(this.$outer.f$1)).input(Reader$.MODULE$.stringCharReader(), (Mode)Mode$.MODULE$.defaultMode())).$greater(out, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        out.close();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.htmlDoc$1 = htmlDoc$1;
                    }
                }, encodings$.MODULE$.UTF$minus8().apply());
            }
            {
                this.f$1 = f$1;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public Object stringHandler(Encoding enc) {
        return new HttpHandler<String>(enc){
            private final Encoding enc$3;

            public <S> HttpHandler<S> contraMap(Function1<S, String> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public StreamResponse response(String t) {
                return new StreamResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), MimeTypes$.MODULE$.text$divplain(), (Function1<Output<Object>, BoxedUnit>)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final String t$2;

                    public final void apply(Output<Object> os) {
                        package$.MODULE$.readable(package$.MODULE$.readable((Object)this.t$2).input(Reader$.MODULE$.stringCharReader(), (Mode)Mode$.MODULE$.defaultMode())).$greater(os, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        os.close();
                    }
                    {
                        this.t$2 = t$2;
                    }
                }, this.enc$3);
            }
            {
                this.enc$3 = enc$3;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public Object byteInputHandleri(MimeTypes.MimeType mimeType) {
        return new HttpHandler<Input<Object>>(mimeType){
            private final MimeTypes.MimeType mimeType$2;

            public <S> HttpHandler<S> contraMap(Function1<S, Input<Object>> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public ByteStreamResponse response(Input<Object> in) {
                return new ByteStreamResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), this.mimeType$2, (Function1<Output<Object>, BoxedUnit>)new Serializable(this, in){
                    public static final long serialVersionUID = 0L;
                    private final Input in$3;

                    public final void apply(Output<Object> os) {
                        package$.MODULE$.readable((Object)this.in$3).$greater(os, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Byte());
                        os.close();
                    }
                    {
                        this.in$3 = in$3;
                    }
                });
            }
            {
                this.mimeType$2 = mimeType$2;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public Object fileHandler() {
        return new HttpHandler<FsUrl>(){

            public <S> HttpHandler<S> contraMap(Function1<S, FsUrl> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public FileResponse response(FsUrl file) {
                return new FileResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), (MimeTypes.MimeType)((TraversableLike)((Option)file.extension((Mode)Mode$.MODULE$.defaultMode())).toList().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MimeTypes.MimeType> apply(String ext) {
                        return MimeTypes$.MODULE$.extension(ext);
                    }
                }, List$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MimeTypes.MimeType apply() {
                        return MimeTypes$.MODULE$.text$divplain();
                    }
                }), file);
            }
            {
                HttpHandler$class.$init$(this);
            }
        };
    }

    public <T> HttpHandler<Cached<T>> cacheHandler(HttpHandler<T> h) {
        return new HttpHandler<Cached<T>>(h){
            private final HttpHandler h$1;

            public <S> HttpHandler<S> contraMap(Function1<S, Cached<T>> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public Response response(Cached<T> resp) {
                Response response2;
                block8: {
                    Product product;
                    block3: {
                        List lastModified;
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            Response r = this.h$1.response(resp.toCache());
                                            DateFormat dateFormat = new DateFormat("EEE, d MMM yyyy");
                                            TimeFormat timeFormat = new TimeFormat("HH:mm:ss z");
                                            lastModified = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Last-modified"), (Object)resp.lastModified().format(dateFormat, timeFormat))}));
                                            response2 = r;
                                            if (!(response2 instanceof BufferResponse)) break block2;
                                            BufferResponse bufferResponse = (BufferResponse)response2;
                                            int code = bufferResponse.code();
                                            MimeTypes.MimeType contentType = bufferResponse.contentType();
                                            ByteBuffer[] buffers = bufferResponse.buffers();
                                            product = new BufferResponse(code, (Seq<Tuple2<String, String>>)lastModified, contentType, buffers);
                                            break block3;
                                        }
                                        if (!(response2 instanceof StreamResponse)) break block4;
                                        StreamResponse streamResponse = (StreamResponse)response2;
                                        int code = streamResponse.code();
                                        MimeTypes.MimeType contentType = streamResponse.contentType();
                                        Function1<Output<Object>, BoxedUnit> send = streamResponse.send();
                                        product = new StreamResponse(code, (Seq<Tuple2<String, String>>)lastModified, contentType, send, streamResponse.encoding());
                                        break block3;
                                    }
                                    if (!(response2 instanceof ByteStreamResponse)) break block5;
                                    ByteStreamResponse byteStreamResponse = (ByteStreamResponse)response2;
                                    int code = byteStreamResponse.code();
                                    MimeTypes.MimeType contentType = byteStreamResponse.contentType();
                                    Function1<Output<Object>, BoxedUnit> send = byteStreamResponse.send();
                                    product = new ByteStreamResponse(code, (Seq<Tuple2<String, String>>)lastModified, contentType, send);
                                    break block3;
                                }
                                if (!(response2 instanceof ErrorResponse)) break block6;
                                ErrorResponse errorResponse = (ErrorResponse)response2;
                                int code = errorResponse.code();
                                String message = errorResponse.message();
                                String detail = errorResponse.detail();
                                product = new ErrorResponse(code, (Seq<Tuple2<String, String>>)lastModified, message, detail);
                                break block3;
                            }
                            if (!(response2 instanceof FileResponse)) break block7;
                            FileResponse fileResponse = (FileResponse)response2;
                            int code = fileResponse.code();
                            MimeTypes.MimeType contentType = fileResponse.contentType();
                            FsUrl file = fileResponse.file();
                            product = new FileResponse(code, (Seq<Tuple2<String, String>>)lastModified, contentType, file);
                            break block3;
                        }
                        if (!(response2 instanceof RedirectResponse)) break block8;
                        RedirectResponse redirectResponse = (RedirectResponse)response2;
                        String location = redirectResponse.location();
                        product = new RedirectResponse((Seq<Tuple2<String, String>>)lastModified, location);
                    }
                    return product;
                }
                throw new MatchError((Object)response2);
            }
            {
                this.h$1 = h$1;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public <T> HttpHandler<Attachment<T>> attachmentHandler(HttpHandler<T> h) {
        return new HttpHandler<Attachment<T>>(h){
            private final HttpHandler h$2;

            public <S> HttpHandler<S> contraMap(Function1<S, Attachment<T>> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public Response response(Attachment<T> resp) {
                Response response2;
                block8: {
                    Product product;
                    block3: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            Response r = this.h$2.response(resp.original());
                                            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"Content-Disposition"), (Object)new StringBuilder().append((Object)"attachment; filename=").append((Object)resp.filename()).toString());
                                            List headers = r.headers().toList().$colon$colon((Object)tuple2);
                                            response2 = r;
                                            if (!(response2 instanceof BufferResponse)) break block2;
                                            BufferResponse bufferResponse = (BufferResponse)response2;
                                            int code = bufferResponse.code();
                                            Seq<Tuple2<String, String>> headers2 = bufferResponse.headers();
                                            MimeTypes.MimeType contentType = bufferResponse.contentType();
                                            ByteBuffer[] buffers = bufferResponse.buffers();
                                            product = new BufferResponse(code, headers2, contentType, buffers);
                                            break block3;
                                        }
                                        if (!(response2 instanceof StreamResponse)) break block4;
                                        StreamResponse streamResponse = (StreamResponse)response2;
                                        int code = streamResponse.code();
                                        Seq<Tuple2<String, String>> headers = streamResponse.headers();
                                        MimeTypes.MimeType contentType = streamResponse.contentType();
                                        Function1<Output<Object>, BoxedUnit> send = streamResponse.send();
                                        product = new StreamResponse(code, headers, contentType, send, streamResponse.encoding());
                                        break block3;
                                    }
                                    if (!(response2 instanceof ByteStreamResponse)) break block5;
                                    ByteStreamResponse byteStreamResponse = (ByteStreamResponse)response2;
                                    int code = byteStreamResponse.code();
                                    Seq<Tuple2<String, String>> headers = byteStreamResponse.headers();
                                    MimeTypes.MimeType contentType = byteStreamResponse.contentType();
                                    Function1<Output<Object>, BoxedUnit> send = byteStreamResponse.send();
                                    product = new ByteStreamResponse(code, headers, contentType, send);
                                    break block3;
                                }
                                if (!(response2 instanceof ErrorResponse)) break block6;
                                ErrorResponse errorResponse = (ErrorResponse)response2;
                                int code = errorResponse.code();
                                Seq<Tuple2<String, String>> headers = errorResponse.headers();
                                String message = errorResponse.message();
                                String detail = errorResponse.detail();
                                product = new ErrorResponse(code, headers, message, detail);
                                break block3;
                            }
                            if (!(response2 instanceof FileResponse)) break block7;
                            FileResponse fileResponse = (FileResponse)response2;
                            int code = fileResponse.code();
                            Seq<Tuple2<String, String>> headers = fileResponse.headers();
                            MimeTypes.MimeType contentType = fileResponse.contentType();
                            FsUrl file = fileResponse.file();
                            product = new FileResponse(code, headers, contentType, file);
                            break block3;
                        }
                        if (!(response2 instanceof RedirectResponse)) break block8;
                        RedirectResponse redirectResponse = (RedirectResponse)response2;
                        Seq<Tuple2<String, String>> headers = redirectResponse.headers();
                        String location = redirectResponse.location();
                        product = new RedirectResponse(headers, location);
                    }
                    return product;
                }
                throw new MatchError((Object)response2);
            }
            {
                this.h$2 = h$2;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public <T> HttpHandler<Future<T>> futureHandler(HttpHandler<T> h, ExecutionContext ec) {
        return new HttpHandler<Future<T>>(h){
            private final HttpHandler h$3;

            public <S> HttpHandler<S> contraMap(Function1<S, Future<T>> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public Response response(Future<T> future) {
                return this.h$3.response(Await$.MODULE$.result(future, (Duration)Duration$.MODULE$.Inf()));
            }
            {
                this.h$3 = h$3;
                HttpHandler$class.$init$(this);
            }
        };
    }

    public Object nullHandler() {
        return this.nullHandler;
    }

    public Object jsonHandler(Encoding enc) {
        return new HttpHandler<Json>(enc){
            private final Encoding enc$4;

            public <S> HttpHandler<S> contraMap(Function1<S, Json> fn) {
                return HttpHandler$class.contraMap(this, fn);
            }

            public StreamResponse response(Json t) {
                return new StreamResponse(200, (Seq<Tuple2<String, String>>)Response$.MODULE$.NoCache(), MimeTypes$.MODULE$.application$divjson(), (Function1<Output<Object>, BoxedUnit>)new Serializable(this, t){
                    public static final long serialVersionUID = 0L;
                    private final Json t$3;

                    public final void apply(Output<Object> os) {
                        package$.MODULE$.readable(package$.MODULE$.readable((Object)this.t$3.toString()).input(Reader$.MODULE$.stringCharReader(), (Mode)Mode$.MODULE$.defaultMode())).$greater(os, Reader$.MODULE$.inputStreamReader(), (Mode)Mode$.MODULE$.defaultMode(), ClassTag$.MODULE$.Char());
                        os.close();
                    }
                    {
                        this.t$3 = t$3;
                    }
                }, this.enc$4);
            }
            {
                this.enc$4 = enc$4;
                HttpHandler$class.$init$(this);
            }
        };
    }

    private HttpHandler$() {
        MODULE$ = this;
        HttpHandler_1$class.$init$(this);
        this.StringInputHandler = new anon.4();
        this.nullHandler = new anon.6();
    }
}

