/*
 * Decompiled with CFR 0.152.
 */
package com.provectus.kafka.ui.serde.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public final class DeserializeResult {
    private final String result;
    private final Type type;
    private final Map<String, Object> additionalProperties;

    public DeserializeResult(String result, Type type, Map<String, Object> additionalProperties) {
        this.result = result;
        this.type = type != null ? type : Type.STRING;
        this.additionalProperties = additionalProperties != null ? additionalProperties : Collections.emptyMap();
    }

    public String getResult() {
        return this.result;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Type getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeserializeResult that = (DeserializeResult)o;
        return Objects.equals(this.result, that.result) && this.type == that.type && this.additionalProperties.equals(that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.result, this.type, this.additionalProperties});
    }

    public String toString() {
        return "DeserializeResult{result='" + this.result + '\'' + ", type=" + (Object)((Object)this.type) + ", additionalProperties=" + this.additionalProperties + '}';
    }

    public static enum Type {
        STRING,
        JSON;

    }
}

