/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrParser;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.NamespaceReader;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.sax.SAXSource;
import org.apache.commons.lang3.Validate;

public class MxReadImpl
implements MxRead {
    private static final transient Logger log = Logger.getLogger(MxReadImpl.class.getName());

    @Override
    public AbstractMX read(Class<? extends AbstractMX> targetClass, String xml, Class<?>[] classes) {
        return MxReadImpl.parse(targetClass, xml, classes);
    }

    public static AbstractMX parse(Class<? extends AbstractMX> targetClass, String xml, Class<?>[] classes) {
        Validate.notNull(targetClass, (String)"target class to parse must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)xml, (String)"XML to parse must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Validate.notNull(classes, (String)"object model classes array must not be null", (Object[])new Object[0]);
        try {
            SAXSource documentSource = MxParseUtils.createFilteredSAXSource(xml, "Document");
            Optional<AbstractMX> mx = MxReadImpl.parseDocumentFromSAXSource(documentSource, targetClass, classes);
            Optional<AppHdr> appHdr = AppHdrParser.parse(xml);
            if (mx.isPresent() && appHdr.isPresent()) {
                mx.get().setAppHdr(appHdr.get());
            }
            return mx.orElse(null);
        }
        catch (Exception e) {
            MxParseUtils.handleParseException(e);
            return null;
        }
    }

    private static Optional<AbstractMX> parseDocumentFromSAXSource(SAXSource source, Class<? extends AbstractMX> targetClass, Class<?>[] classes) {
        AbstractMX mx = (AbstractMX)MxParseUtils.parseSAXSource(source, targetClass, classes);
        return Optional.ofNullable(mx);
    }

    @Override
    public AbstractMX read(String xml, MxId id) {
        return MxReadImpl.parse(xml, id);
    }

    public static AbstractMX parse(String xml, MxId id) {
        Validate.notNull((Object)xml, (String)"XML to parse must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        MxId resolvedId = id;
        if (id == null) {
            Optional<String> namespace = NamespaceReader.findDocumentNamespace(xml);
            if (namespace.isPresent()) {
                resolvedId = new MxId(namespace.get());
            } else {
                log.severe("Cannot detect the Mx type from the XML, ensure the XML contains proper namespaces or provide an MxId object as parameter to the parse call");
                return null;
            }
        }
        AbstractMX mx = null;
        String fqn = null;
        try {
            String subPackage = resolvedId.getBusinessProcess() == MxBusinessProcess.xsys ? ".sys" : "";
            fqn = "com.prowidesoftware.swift.model.mx" + subPackage + ".Mx" + resolvedId.camelized();
            Class<?> clazz = Class.forName(fqn);
            Field _classes = clazz.getDeclaredField("_classes");
            mx = MxReadImpl.parse(clazz, xml, (Class[])_classes.get(null));
        }
        catch (ClassNotFoundException e) {
            log.log(Level.SEVERE, "MX model implementation not found for " + fqn, e);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error calling parse in specific MX model implementation", e);
        }
        return mx;
    }
}

