/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.StringReader;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

class NamespaceReader {
    private static final transient Logger log = Logger.getLogger(NamespaceReader.class.getName());

    NamespaceReader() {
    }

    static Optional<String> findDocumentNamespace(String xml) {
        return NamespaceReader.findNamespaceForLocalName(xml, "Document");
    }

    static Optional<String> findAppHdrNamespace(String xml) {
        return NamespaceReader.findNamespaceForLocalName(xml, "AppHdr");
    }

    private static Optional<String> findNamespaceForLocalName(String xml, String localName) {
        Optional<XMLStreamReader> reader = NamespaceReader.findElement(xml, localName);
        if (reader.isPresent()) {
            return Optional.ofNullable(NamespaceReader.readNamespace(reader.get()));
        }
        return Optional.empty();
    }

    private static String readNamespace(XMLStreamReader reader) {
        if (reader.getNamespaceCount() > 0) {
            for (int nsIndex = 0; nsIndex < reader.getNamespaceCount(); ++nsIndex) {
                String elementPrefix;
                String nsPrefix = StringUtils.trimToNull((String)reader.getNamespacePrefix(nsIndex));
                if (!StringUtils.equals((CharSequence)nsPrefix, (CharSequence)(elementPrefix = StringUtils.trimToNull((String)reader.getPrefix())))) continue;
                return reader.getNamespaceURI(nsIndex);
            }
        }
        return null;
    }

    static boolean elementExists(String xml, String localName) {
        return NamespaceReader.findElement(xml, localName).isPresent();
    }

    private static Optional<XMLStreamReader> findElement(String xml, String localName) {
        Validate.notNull((Object)xml, (String)"XML to parse must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)xml, (String)"XML to parse must not be a blank string", (Object[])new Object[0]);
        Validate.notNull((Object)xml, (String)"localName to find must not be null", (Object[])new Object[0]);
        XMLInputFactory xif = SafeXmlUtils.inputFactory();
        try {
            XMLStreamReader reader = xif.createXMLStreamReader(new StringReader(xml));
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event || !reader.getLocalName().equals(localName)) continue;
                return Optional.of(reader);
            }
        }
        catch (XMLStreamException e) {
            log.log(Level.WARNING, "Error reading XML", e);
        }
        return Optional.empty();
    }
}

