/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.parser.MxParser;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrParser;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.LegacyAppHdr;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Entity(name="mx")
@DiscriminatorValue(value="mx")
public class MxSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = -4394356007627575831L;
    private static final transient Logger log = Logger.getLogger(MxSwiftMessage.class.getName());
    @Enumerated(value=EnumType.STRING)
    @Column(length=4, name="business_process")
    private MxBusinessProcess businessProcess;
    @Column(length=3)
    private String functionality;
    @Column(length=3)
    private String variant;
    @Column(length=2)
    private String version;

    public MxSwiftMessage() {
    }

    public MxSwiftMessage(String xml) {
        super(xml);
    }

    public static MxSwiftMessage parse(String xml) {
        return new MxSwiftMessage(xml);
    }

    public MxSwiftMessage(InputStream stream) throws IOException {
        super(stream);
    }

    public static MxSwiftMessage parse(InputStream stream) throws IOException {
        return new MxSwiftMessage(stream);
    }

    public MxSwiftMessage(File file) throws IOException {
        super(file);
    }

    public static MxSwiftMessage parse(File file) throws IOException {
        return new MxSwiftMessage(file);
    }

    public MxSwiftMessage(AbstractMX mx) {
        this.setMessage(mx.message());
        this._updateFromMessage(mx.getMxId());
    }

    protected void updateFromMessage() {
        this._updateFromMessage(null);
    }

    private void _updateFromMessage(MxId id) {
        if (this.message() != null && this.message().length() > 0) {
            Optional<AppHdr> h = AppHdrParser.parse(this.message());
            if (h.isPresent()) {
                this._update(h.get());
            } else {
                this._update(MxNode.parse(this.message()));
            }
            if (id != null) {
                this._update(id);
            } else {
                Optional<MxId> detectedId = MxParseUtils.identifyMessage(this.message());
                if (detectedId.isPresent()) {
                    this._update(detectedId.get());
                }
            }
        }
    }

    public void updateFromXML(String xml) {
        this.updateFromXML(xml, null);
    }

    public void updateFromXML(String xml, MxId id) {
        Validate.notNull((Object)xml, (String)"the xml message parameter cannot be null", (Object[])new Object[0]);
        this.setMessage(xml);
        this.setFileFormat(FileFormat.MX);
        this._updateFromMessage(id);
    }

    public void updateFromModel(AbstractMX mx) {
        Validate.notNull((Object)mx, (String)"the mx parameter cannot be null", (Object[])new Object[0]);
        this.setMessage(mx.message());
        this.setFileFormat(FileFormat.MX);
        if (!this._update(mx.getAppHdr())) {
            this._update(MxNode.parse(this.message()));
        }
        this._update(mx.getMxId());
    }

    private boolean _update(MxId id) {
        if (id != null) {
            this.identifier = id.id();
            this.businessProcess = id.getBusinessProcess();
            this.functionality = id.getFunctionality();
            this.variant = id.getVariant();
            this.version = id.getVersion();
            return true;
        }
        return false;
    }

    private boolean _update(AppHdr h) {
        boolean updated = false;
        if (h != null) {
            String reference;
            String to;
            String from = h.from();
            if (from != null) {
                this.sender = this.bic11(from);
                updated = true;
            }
            if ((to = h.to()) != null) {
                this.receiver = this.bic11(to);
                updated = true;
            }
            if ((reference = h.reference()) != null) {
                this.setReference(h.reference());
                updated = true;
            }
        }
        return updated;
    }

    private boolean _update(MxNode n) {
        MxNode groupHeader;
        boolean updated = false;
        MxNode mxNode = groupHeader = n != null ? n.findFirstByName("GrpHdr") : null;
        if (groupHeader != null) {
            MxNode reference;
            MxNode receiverBic;
            MxNode senderBic = groupHeader.findFirst("./InstgAgt/FinInstnId/BIC");
            if (senderBic != null) {
                this.sender = this.bic11(senderBic.getValue());
                updated = true;
            }
            if ((receiverBic = groupHeader.findFirst("./InstdAgt/FinInstnId/BIC")) != null) {
                this.receiver = this.bic11(receiverBic.getValue());
                updated = true;
            }
            if ((reference = groupHeader.findFirst("./MsgId")) != null) {
                this.setReference(reference.getValue());
                updated = true;
            }
        }
        return updated;
    }

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String functionality) {
        this.functionality = functionality;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MxSwiftMessage that = (MxSwiftMessage)((Object)o);
        return this.businessProcess == that.businessProcess && Objects.equals(this.functionality, that.functionality) && Objects.equals(this.variant, that.variant) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.businessProcess, this.functionality, this.variant, this.version});
    }

    @Deprecated
    public BusinessHeader getBusinessHeader() {
        MxParser parser = new MxParser(this.message());
        return parser.parseBusinessHeader();
    }

    public AppHdr getAppHdr() {
        return AppHdrParser.parse(this.message()).orElse(null);
    }

    @Deprecated
    public ApplicationHeader getApplicationHeader() {
        DeprecationUtils.phase3(((Object)((Object)this)).getClass(), (String)"getApplicationHeader()", (String)"use getAppHdr() instead");
        Optional<AppHdr> optionalAppHdr = AppHdrParser.parse(this.message());
        if (optionalAppHdr.isPresent() && optionalAppHdr.get() instanceof LegacyAppHdr) {
            ApplicationHeader result = new ApplicationHeader();
            LegacyAppHdr legacyHdr = (LegacyAppHdr)optionalAppHdr.get();
            result.setFrom(legacyHdr.getFrom());
            result.setTo(legacyHdr.getTo());
            result.setSvcName(legacyHdr.getSvcName());
            result.setMsgName(legacyHdr.getMsgName());
            result.setMsgRef(legacyHdr.getMsgRef());
            result.setCrDate(legacyHdr.getCrDate());
            result.setDup(legacyHdr.getDup());
            return result;
        }
        return null;
    }

    @Deprecated
    public void setApplicationHeader(ApplicationHeader applicationHeader) {
        String message = "Obsolete API call. The application header is no longer stored as class attribute in " + ((Object)((Object)this)).getClass().getName();
        DeprecationUtils.phase3(((Object)((Object)this)).getClass(), (String)"setApplicationHeader(ApplicationHeader)", (String)message);
    }

    public void copyTo(MxSwiftMessage msg) {
        super.copyTo((AbstractSwiftMessage)msg);
        msg.setBusinessProcess(this.getBusinessProcess());
        msg.setFunctionality(this.getFunctionality());
        msg.setVariant(this.getVariant());
        msg.setVersion(this.getVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MxSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }

    public static MxSwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (MxSwiftMessage)((Object)gson.fromJson(json, MxSwiftMessage.class));
    }

    public MxId getMxId() {
        return new MxId(this.businessProcess, this.functionality, this.variant, this.version);
    }

    public String getCategory() {
        MxBusinessProcess proc;
        if (!StringUtils.isBlank((CharSequence)this.identifier) && (proc = new MxId(this.identifier).getBusinessProcess()) != null) {
            return proc.name();
        }
        return "";
    }
}

