/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.XMLGregorianCalendarUtils;
import com.prowidesoftware.swift.model.mx.XmlEventWriter;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV02Impl;
import com.prowidesoftware.swift.model.mx.dic.Party44Choice;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="AppHdr")
@XmlRootElement(name="AppHdr", namespace="urn:iso:std:iso:20022:tech:xsd:head.001.001.02")
public class BusinessAppHdrV02
extends BusinessApplicationHeaderV02Impl
implements AppHdr {
    private static final transient Logger log = Logger.getLogger(BusinessAppHdrV02.class.getName());
    public static final transient String NAMESPACE = "urn:iso:std:iso:20022:tech:xsd:head.001.001.02";
    static final transient Class[] _classes = Arrays.copyOf(BusinessApplicationHeaderV02Impl._classes, BusinessApplicationHeaderV02Impl._classes.length + 1);

    Class[] getClasses() {
        return _classes;
    }

    public static BusinessAppHdrV02 parse(String xml) {
        return (BusinessAppHdrV02)MxParseUtils.parse(BusinessAppHdrV02.class, xml, _classes, "AppHdr");
    }

    @Override
    public String from() {
        return this.getBIC(this.getFr());
    }

    @Override
    public String to() {
        return this.getBIC(this.getTo());
    }

    private String getBIC(Party44Choice p) {
        try {
            String found = p.getFIId().getFinInstnId().getBICFI();
            if (!StringUtils.isEmpty((CharSequence)found)) {
                return found;
            }
        }
        catch (NullPointerException e) {
            try {
                String found = p.getOrgId().getId().getOrgId().getAnyBIC();
                if (!StringUtils.isEmpty((CharSequence)found)) {
                    return found;
                }
            }
            catch (NullPointerException e2) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String reference() {
        return this.getBizMsgIdr();
    }

    @Override
    public String messageName() {
        return this.getMsgDefIdr();
    }

    @Override
    public String serviceName() {
        return this.getBizSvc();
    }

    @Override
    public boolean duplicate() {
        return this.isPssblDplct() != null && this.isPssblDplct() != false || this.getCpyDplct() != null;
    }

    @Override
    public XMLGregorianCalendar creationDate() {
        return this.getCreDt();
    }

    @Override
    public void setCreationDate(boolean overwrite) {
        if (this.getCreDt() == null || overwrite) {
            this.setCreDt(XMLGregorianCalendarUtils.now());
        }
    }

    @Override
    public String xml(String prefix, boolean includeXMLDeclaration) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{BusinessApplicationHeaderV02Impl.class});
            Marshaller marshaller = context.createMarshaller();
            StringWriter sw = new StringWriter();
            JAXBElement element = new JAXBElement(new QName(NAMESPACE, "AppHdr"), BusinessApplicationHeaderV02Impl.class, null, (Object)this);
            marshaller.marshal((Object)element, (XMLEventWriter)new XmlEventWriter(sw, prefix, includeXMLDeclaration, "AppHdr"));
            return sw.getBuffer().toString();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing head.001.001.02 XML:" + e.getMessage());
            return null;
        }
    }

    @Override
    public Element element() {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{BusinessApplicationHeaderV02Impl.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            DOMResult res = new DOMResult();
            JAXBElement element = new JAXBElement(new QName(NAMESPACE, "AppHdr"), BusinessApplicationHeaderV02Impl.class, null, (Object)this);
            marshaller.marshal((Object)element, (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (JAXBException e) {
            log.log(Level.SEVERE, "Error writing head.001.001.02 XML:" + e.getMessage());
            return null;
        }
    }

    static {
        BusinessAppHdrV02._classes[BusinessAppHdrV02._classes.length - 1] = BusinessAppHdrV02.class;
    }
}

