/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import org.apache.commons.lang3.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

class NamespaceAndElementFilter
extends XMLFilterImpl {
    private String namespaceUriToRemove;
    private boolean isAnElementToPropagate = false;
    private String localNameToPropagate;

    public NamespaceAndElementFilter(String localName) {
        this.localNameToPropagate = localName;
    }

    @Override
    public void startElement(String nameSpace, String localName, String prefix, Attributes attributes) throws SAXException {
        if (localName.equals(this.localNameToPropagate)) {
            this.isAnElementToPropagate = true;
            this.namespaceUriToRemove = nameSpace;
        }
        if (this.isAnElementToPropagate) {
            String namespaceToPropagate = this.resolveNamespaceToPropagate(nameSpace);
            super.startElement(namespaceToPropagate, localName, prefix, attributes);
        }
    }

    private String resolveNamespaceToPropagate(String nameSpace) {
        return StringUtils.equals((CharSequence)this.namespaceUriToRemove, (CharSequence)nameSpace) ? "" : nameSpace;
    }

    @Override
    public void endElement(String nameSpace, String localName, String prefix) throws SAXException {
        if (this.isAnElementToPropagate) {
            String namespaceToPropagate = this.resolveNamespaceToPropagate(nameSpace);
            super.endElement(namespaceToPropagate, localName, prefix);
        }
        if (localName.equals(this.localNameToPropagate)) {
            this.isAnElementToPropagate = false;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String url) throws SAXException {
        if (this.isAnElementToPropagate && this.namespaceUriToRemove != null && !StringUtils.equals((CharSequence)url, (CharSequence)this.namespaceUriToRemove)) {
            super.startPrefixMapping(prefix, url);
        }
    }
}

