
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.dic.*;
import com.prowidesoftware.swift.model.mx.AbstractMX;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.prowidesoftware.swift.model.MxSwiftMessage;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Class for camt.018.001.01 ISO 20022 message.
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Document", propOrder = {
    "camt01800101"
})
@XmlRootElement(name = "Document", namespace = "urn:swift:xsd:camt.018.001.01")
public class MxCamt01800101
    extends AbstractMX
{

    @XmlElement(name = "camt.018.001.01", required = true)
    protected Camt01800101 camt01800101;
    public final static transient String BUSINESS_PROCESS = "camt";
    public final static transient int FUNCTIONALITY = 18;
    public final static transient int VARIANT = 1;
    public final static transient int VERSION = 1;
    @SuppressWarnings("rawtypes")
    public final static transient Class[] _classes = new Class[] {BusinessDayInformationCriteria.class, BusinessDayInformationCriteriaDefinitionChoice.class, BusinessDayInformationQueryDefinition.class, BusinessDayInformationReturnCriteria.class, BusinessDayInformationSearchCriteria.class, Camt01800101 .class, CashClearingSystem1Code.class, MessageIdentification.class, MxCamt01800101 .class, QueryType1Code.class, SystemIdentificationChoice.class };
    public final static transient String NAMESPACE = "urn:swift:xsd:camt.018.001.01";

    public MxCamt01800101() {
        super();
    }

    /**
     * Creates the MX object parsing the parameter String with the XML content
     * 
     */
    public MxCamt01800101(final String xml) {
        this();
        MxCamt01800101 tmp = parse(xml);
        camt01800101 = tmp.getCamt01800101();
    }

    /**
     * Creates the MX object parsing the raw content from the parameter MxSwiftMessage
     * 
     */
    public MxCamt01800101(final MxSwiftMessage mxSwiftMessage) {
        this(mxSwiftMessage.message());
    }

    /**
     * Gets the value of the camt01800101 property.
     * 
     * @return
     *     possible object is
     *     {@link Camt01800101 }
     *     
     */
    public Camt01800101 getCamt01800101() {
        return camt01800101;
    }

    /**
     * Sets the value of the camt01800101 property.
     * 
     * @param value
     *     allowed object is
     *     {@link Camt01800101 }
     *     
     */
    public MxCamt01800101 setCamt01800101(Camt01800101 value) {
        this.camt01800101 = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public String getBusinessProcess() {
        return BUSINESS_PROCESS;
    }

    @Override
    public int getFunctionality() {
        return FUNCTIONALITY;
    }

    @Override
    public int getVariant() {
        return VARIANT;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML
     * 
     */
    public static MxCamt01800101 parse(String xml) {
        return ((MxCamt01800101) MxReadImpl.parse(MxCamt01800101 .class, xml, _classes));
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML with injected read implementation
     * @since 9.0.1
     * 
     * @param parserImpl an MX unmarshall implementation
     */
    public static MxCamt01800101 parse(String xml, MxRead parserImpl) {
        return ((MxCamt01800101) parserImpl.read(MxCamt01800101 .class, xml, _classes));
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public Class[] getClasses() {
        return _classes;
    }

    /**
     * Creates an MxCamt01800101 messages from its JSON representation.
     * <p>
     * For generic conversion of JSON into the corresponding MX instance 
     * see {@link AbstractMX#fromJson(String)}
     * 
     * @since 7.10.2
     * 
     * @param json a JSON representation of an MxCamt01800101 message
     * @return
     *     a new instance of MxCamt01800101
     */
    public final static MxCamt01800101 fromJson(String json) {
        return AbstractMX.fromJson(json, MxCamt01800101 .class);
    }

}
