
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TradeType1Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="TradeType1Code"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="OOBK"/&gt;
 *     &lt;enumeration value="OFBK"/&gt;
 *     &lt;enumeration value="BKTR"/&gt;
 *     &lt;enumeration value="COTR"/&gt;
 *     &lt;enumeration value="GUTR"/&gt;
 *     &lt;enumeration value="LKTR"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "TradeType1Code")
@XmlEnum
public enum TradeType1Code {


    /**
     * On order book/market trade.
     * 
     */
    OOBK,

    /**
     * Trade that is over the counter.
     * 
     */
    OFBK,

    /**
     * Trade that is input manually in case of issue on the original trade that either was not processed or not received.
     * 
     */
    BKTR,

    /**
     * Trade that is generated following a corporate action.
     * 
     */
    COTR,

    /**
     * Trade generated by a give-up.
     * 
     */
    GUTR,

    /**
     * Trades coming from the application of a coorporate event.
     * 
     */
    LKTR;

    public String value() {
        return name();
    }

    public static TradeType1Code fromValue(String v) {
        return valueOf(v);
    }

}
