
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.dic.*;
import com.prowidesoftware.swift.model.mx.AbstractMX;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.prowidesoftware.swift.model.MxSwiftMessage;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Class for fxtr.013.001.03 ISO 20022 message.
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Document", propOrder = {
    "fxTradWdrwlNtfctn"
})
@XmlRootElement(name = "Document", namespace = "urn:iso:std:iso:20022:tech:xsd:fxtr.013.001.03")
public class MxFxtr01300103
    extends AbstractMX
{

    @XmlElement(name = "FXTradWdrwlNtfctn", required = true)
    protected ForeignExchangeTradeWithdrawalNotificationV03 fxTradWdrwlNtfctn;
    public final static transient String BUSINESS_PROCESS = "fxtr";
    public final static transient int FUNCTIONALITY = 13;
    public final static transient int VARIANT = 1;
    public final static transient int VERSION = 3;
    @SuppressWarnings("rawtypes")
    public final static transient Class[] _classes = new Class[] {ForeignExchangeTradeWithdrawalNotificationV03 .class, MxFxtr01300103 .class, SupplementaryData1 .class, SupplementaryDataEnvelope1 .class, WithdrawalReason1 .class, WithdrawalReason1Code.class };
    public final static transient String NAMESPACE = "urn:iso:std:iso:20022:tech:xsd:fxtr.013.001.03";

    public MxFxtr01300103() {
        super();
    }

    /**
     * Creates the MX object parsing the parameter String with the XML content
     * 
     */
    public MxFxtr01300103(final String xml) {
        this();
        MxFxtr01300103 tmp = parse(xml);
        fxTradWdrwlNtfctn = tmp.getFXTradWdrwlNtfctn();
    }

    /**
     * Creates the MX object parsing the raw content from the parameter MxSwiftMessage
     * 
     */
    public MxFxtr01300103(final MxSwiftMessage mxSwiftMessage) {
        this(mxSwiftMessage.message());
    }

    /**
     * Gets the value of the fxTradWdrwlNtfctn property.
     * 
     * @return
     *     possible object is
     *     {@link ForeignExchangeTradeWithdrawalNotificationV03 }
     *     
     */
    public ForeignExchangeTradeWithdrawalNotificationV03 getFXTradWdrwlNtfctn() {
        return fxTradWdrwlNtfctn;
    }

    /**
     * Sets the value of the fxTradWdrwlNtfctn property.
     * 
     * @param value
     *     allowed object is
     *     {@link ForeignExchangeTradeWithdrawalNotificationV03 }
     *     
     */
    public MxFxtr01300103 setFXTradWdrwlNtfctn(ForeignExchangeTradeWithdrawalNotificationV03 value) {
        this.fxTradWdrwlNtfctn = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public String getBusinessProcess() {
        return BUSINESS_PROCESS;
    }

    @Override
    public int getFunctionality() {
        return FUNCTIONALITY;
    }

    @Override
    public int getVariant() {
        return VARIANT;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML
     * 
     */
    public static MxFxtr01300103 parse(String xml) {
        return ((MxFxtr01300103) MxReadImpl.parse(MxFxtr01300103 .class, xml, _classes));
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML with injected read implementation
     * @since 9.0.1
     * 
     * @param parserImpl an MX unmarshall implementation
     */
    public static MxFxtr01300103 parse(String xml, MxRead parserImpl) {
        return ((MxFxtr01300103) parserImpl.read(MxFxtr01300103 .class, xml, _classes));
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public Class[] getClasses() {
        return _classes;
    }

    /**
     * Creates an MxFxtr01300103 messages from its JSON representation.
     * <p>
     * For generic conversion of JSON into the corresponding MX instance 
     * see {@link AbstractMX#fromJson(String)}
     * 
     * @since 7.10.2
     * 
     * @param json a JSON representation of an MxFxtr01300103 message
     * @return
     *     a new instance of MxFxtr01300103
     */
    public final static MxFxtr01300103 fromJson(String json) {
        return AbstractMX.fromJson(json, MxFxtr01300103 .class);
    }

}
