
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.dic.*;
import com.prowidesoftware.swift.model.mx.AbstractMX;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.prowidesoftware.swift.model.MxSwiftMessage;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Class for acmt.003.001.04 ISO 20022 message.
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Document", propOrder = {
    "acctModInstr"
})
@XmlRootElement(name = "Document", namespace = "urn:swift:xsd:acmt.003.001.04")
public class MxAcmt00300104
    extends AbstractMX
{

    @XmlElement(name = "AcctModInstr", required = true)
    protected AccountModificationInstructionV04 acctModInstr;
    public final static transient String BUSINESS_PROCESS = "acmt";
    public final static transient int FUNCTIONALITY = 3;
    public final static transient int VARIANT = 1;
    public final static transient int VERSION = 4;
    @SuppressWarnings("rawtypes")
    public final static transient Class[] _classes = new Class[] {Account2 .class, AccountIdentification1 .class, AccountIdentificationAndName3 .class, AccountModificationInstructionV04 .class, AccountOwnershipType3Code.class, AccountParties3Choice.class, AccountParties8 .class, AccountType1Choice.class, AccountUsageType1Choice.class, AccountUsageType1Code.class, ActiveCurrencyAnd13DecimalAmount.class, ActiveCurrencyAndAmount.class, AdditionalReference3 .class, AddressType1Code.class, AddressType2Code.class, AlternateSecurityIdentification1 .class, Blocked1 .class, BlockedHoldingDetails1 .class, BlockedReason1Choice.class, BlockedReason1Code.class, BranchData.class, CardType1Code.class, CashAccount26 .class, CashAccountIdentification1Choice.class, CertificateType2Code.class, CertificationType1Choice.class, Cheque4 .class, CitizenshipInformation.class, ClearingSystemMemberIdentificationChoice.class, CommunicationAddress3 .class, CommunicationMethod1Code.class, ConductClassification1Code.class, CountryAndResidentialStatusType1 .class, CustomerConductClassification1Choice.class, DataModification1Code.class, DataModification2Code.class, DateAndDateTimeChoice.class, DeMinimusApplicable1 .class, DeMinimusNotApplicable1 .class, DirectDebitMandate4 .class, DistributionPolicy1Code.class, DocumentToSend1 .class, EventFrequency1Code.class, EventFrequency8Code.class, ExtendedParty5 .class, Extension1 .class, FinancialInstitutionIdentification3Choice.class, FinancialInstrument10 .class, FinancialInstrument29 .class, FormOfSecurity1Code.class, Frequency20Choice.class, FundCashAccount2Code.class, FundCashAccount3Code.class, FundOrderType1Choice.class, FundOrderType6Code.class, GenderCode.class, GenericIdentification1 .class, GenericIdentification10 .class, GenericIdentification41 .class, GenericIdentification44 .class, GenericIdentification46 .class, GenericIdentification47 .class, Holding1Code.class, IncomePreference1Code.class, IndividualPerson21 .class, IndividualPerson4 .class, IndividualPersonIdentificationChoice.class, InformationDistribution1Code.class, Insurance1Code.class, InsuranceType1Choice.class, Intermediary24 .class, Intermediary7 .class, InvestmentAccount29 .class, InvestmentAccount39 .class, InvestmentAccountCategory1Choice.class, InvestmentAccountCategory1Code.class, InvestmentAccountModificationDetails.class, InvestmentAccountOwnershipInformation8 .class, InvestmentAccountSelection2 .class, InvestmentAccountType1Choice.class, InvestmentFundCashSettlementInformation8 .class, InvestmentFundRole6Code.class, InvestmentPlan8 .class, KYCCheckType1Choice.class, KnowYourCustomerCheckType1Code.class, LetterIntent1 .class, MarketPracticeVersion1 .class, MessageIdentification1 .class, MiFIDClassification1 .class, ModificationScope1 .class, ModificationScope10 .class, ModificationScope13 .class, ModificationScope17 .class, ModificationScope18 .class, ModificationScope19 .class, ModificationScope20 .class, ModificationScope3 .class, ModificationScope9 .class, MoneyLaunderingCheck1Choice.class, MoneyLaunderingCheck1Code.class, MxAcmt00300104 .class, NameAndAddress4 .class, NameAndAddress5 .class, NamePrefix1Choice.class, NamePrefix1Code.class, NewIssueAllocation1 .class, OrderOriginatorEligibility1Code.class, Organisation15 .class, OtherIdentification1Choice.class, OwnershipType1Choice.class, Party15Choice.class, PartyIdentification2Choice.class, PartyIdentification4Choice.class, PartyIdentification5Choice.class, PartyProfileInformation3 .class, PartyRole2Choice.class, PaymentCard2 .class, PaymentInstrument11 .class, PaymentInstrument12 .class, PaymentInstrument16Choice.class, PaymentInstrument17Choice.class, PersonIdentificationType1Code.class, PersonIdentificationType5Code.class, PoliticalExposureType1Choice.class, PoliticalExposureType1Code.class, PostalAddress1 .class, PostalAddress3 .class, Provided1Code.class, Referred1Code.class, ReferredAgent1 .class, RegulatoryInformation1 .class, Reinvestment1 .class, Repartition2 .class, ResidentialStatus1Code.class, RiskLevel1Choice.class, RiskLevel1Code.class, RoundingDirection1Code.class, RoundingParameters1 .class, SecurityIdentification3Choice.class, SimpleIdentificationInformation.class, StatementFrequencyReason1Choice.class, TaxExemptionReason1Choice.class, TaxWithholdingMethod2Code.class, TransactionChannel2Code.class, TransactionChannelType1Choice.class, UnitsOrAmount1Choice.class };
    public final static transient String NAMESPACE = "urn:swift:xsd:acmt.003.001.04";

    public MxAcmt00300104() {
        super();
    }

    /**
     * Creates the MX object parsing the parameter String with the XML content
     * 
     */
    public MxAcmt00300104(final String xml) {
        this();
        MxAcmt00300104 tmp = parse(xml);
        acctModInstr = tmp.getAcctModInstr();
    }

    /**
     * Creates the MX object parsing the raw content from the parameter MxSwiftMessage
     * 
     */
    public MxAcmt00300104(final MxSwiftMessage mxSwiftMessage) {
        this(mxSwiftMessage.message());
    }

    /**
     * Gets the value of the acctModInstr property.
     * 
     * @return
     *     possible object is
     *     {@link AccountModificationInstructionV04 }
     *     
     */
    public AccountModificationInstructionV04 getAcctModInstr() {
        return acctModInstr;
    }

    /**
     * Sets the value of the acctModInstr property.
     * 
     * @param value
     *     allowed object is
     *     {@link AccountModificationInstructionV04 }
     *     
     */
    public MxAcmt00300104 setAcctModInstr(AccountModificationInstructionV04 value) {
        this.acctModInstr = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public String getBusinessProcess() {
        return BUSINESS_PROCESS;
    }

    @Override
    public int getFunctionality() {
        return FUNCTIONALITY;
    }

    @Override
    public int getVariant() {
        return VARIANT;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML
     * 
     */
    public static MxAcmt00300104 parse(String xml) {
        return ((MxAcmt00300104) MxReadImpl.parse(MxAcmt00300104 .class, xml, _classes));
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML with injected read implementation
     * @since 9.0.1
     * 
     * @param parserImpl an MX unmarshall implementation
     */
    public static MxAcmt00300104 parse(String xml, MxRead parserImpl) {
        return ((MxAcmt00300104) parserImpl.read(MxAcmt00300104 .class, xml, _classes));
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public Class[] getClasses() {
        return _classes;
    }

    /**
     * Creates an MxAcmt00300104 messages from its JSON representation.
     * <p>
     * For generic conversion of JSON into the corresponding MX instance 
     * see {@link AbstractMX#fromJson(String)}
     * 
     * @since 7.10.2
     * 
     * @param json a JSON representation of an MxAcmt00300104 message
     * @return
     *     a new instance of MxAcmt00300104
     */
    public final static MxAcmt00300104 fromJson(String json) {
        return AbstractMX.fromJson(json, MxAcmt00300104 .class);
    }

}
