
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.dic.*;
import com.prowidesoftware.swift.model.mx.AbstractMX;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.prowidesoftware.swift.model.MxSwiftMessage;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Class for camt.027.001.02 ISO 20022 message.
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Document", propOrder = {
    "camt02700102"
})
@XmlRootElement(name = "Document", namespace = "urn:swift:xsd:camt.027.001.02")
public class MxCamt02700102
    extends AbstractMX
{

    @XmlElement(name = "camt.027.001.02", required = true)
    protected Camt02700102 camt02700102;
    public final static transient String BUSINESS_PROCESS = "camt";
    public final static transient int FUNCTIONALITY = 27;
    public final static transient int VARIANT = 1;
    public final static transient int VERSION = 2;
    @SuppressWarnings("rawtypes")
    public final static transient Class[] _classes = new Class[] {Camt02700102 .class, Case.class, CaseAssignment.class, CurrencyAndAmount.class, MissingCover.class, MxCamt02700102 .class, PaymentInstructionExtract2 .class };
    public final static transient String NAMESPACE = "urn:swift:xsd:camt.027.001.02";

    public MxCamt02700102() {
        super();
    }

    /**
     * Creates the MX object parsing the parameter String with the XML content
     * 
     */
    public MxCamt02700102(final String xml) {
        this();
        MxCamt02700102 tmp = parse(xml);
        camt02700102 = tmp.getCamt02700102();
    }

    /**
     * Creates the MX object parsing the raw content from the parameter MxSwiftMessage
     * 
     */
    public MxCamt02700102(final MxSwiftMessage mxSwiftMessage) {
        this(mxSwiftMessage.message());
    }

    /**
     * Gets the value of the camt02700102 property.
     * 
     * @return
     *     possible object is
     *     {@link Camt02700102 }
     *     
     */
    public Camt02700102 getCamt02700102() {
        return camt02700102;
    }

    /**
     * Sets the value of the camt02700102 property.
     * 
     * @param value
     *     allowed object is
     *     {@link Camt02700102 }
     *     
     */
    public MxCamt02700102 setCamt02700102(Camt02700102 value) {
        this.camt02700102 = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public String getBusinessProcess() {
        return BUSINESS_PROCESS;
    }

    @Override
    public int getFunctionality() {
        return FUNCTIONALITY;
    }

    @Override
    public int getVariant() {
        return VARIANT;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML
     * 
     */
    public static MxCamt02700102 parse(String xml) {
        return ((MxCamt02700102) MxReadImpl.parse(MxCamt02700102 .class, xml, _classes));
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML with injected read implementation
     * @since 9.0.1
     * 
     * @param parserImpl an MX unmarshall implementation
     */
    public static MxCamt02700102 parse(String xml, MxRead parserImpl) {
        return ((MxCamt02700102) parserImpl.read(MxCamt02700102 .class, xml, _classes));
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public Class[] getClasses() {
        return _classes;
    }

    /**
     * Creates an MxCamt02700102 messages from its JSON representation.
     * <p>
     * For generic conversion of JSON into the corresponding MX instance 
     * see {@link AbstractMX#fromJson(String)}
     * 
     * @since 7.10.2
     * 
     * @param json a JSON representation of an MxCamt02700102 message
     * @return
     *     a new instance of MxCamt02700102
     */
    public final static MxCamt02700102 fromJson(String json) {
        return AbstractMX.fromJson(json, MxCamt02700102 .class);
    }

}
