
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.dic.*;
import com.prowidesoftware.swift.model.mx.AbstractMX;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import com.prowidesoftware.swift.model.MxSwiftMessage;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.MxRead;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


/**
 * Class for reda.035.001.01 ISO 20022 message.
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Document", propOrder = {
    "sctiesAcctActvtyAdvc"
})
@XmlRootElement(name = "Document", namespace = "urn:iso:std:iso:20022:tech:xsd:reda.035.001.01")
public class MxReda03500101
    extends AbstractMX
{

    @XmlElement(name = "SctiesAcctActvtyAdvc", required = true)
    protected SecuritiesAccountActivityAdviceV01 sctiesAcctActvtyAdvc;
    public final static transient String BUSINESS_PROCESS = "reda";
    public final static transient int FUNCTIONALITY = 35;
    public final static transient int VARIANT = 1;
    public final static transient int VERSION = 1;
    @SuppressWarnings("rawtypes")
    public final static transient Class[] _classes = new Class[] {GenericIdentification30 .class, MessageHeader1 .class, MxReda03500101 .class, Pagination1 .class, SecuritiesAccount19 .class, SecuritiesAccountActivityAdviceV01 .class, SecuritiesAccountReferenceDataChange2 .class, SecuritiesAccountStatement2 .class, SupplementaryData1 .class, SupplementaryDataEnvelope1 .class };
    public final static transient String NAMESPACE = "urn:iso:std:iso:20022:tech:xsd:reda.035.001.01";

    public MxReda03500101() {
        super();
    }

    /**
     * Creates the MX object parsing the parameter String with the XML content
     * 
     */
    public MxReda03500101(final String xml) {
        this();
        MxReda03500101 tmp = parse(xml);
        sctiesAcctActvtyAdvc = tmp.getSctiesAcctActvtyAdvc();
    }

    /**
     * Creates the MX object parsing the raw content from the parameter MxSwiftMessage
     * 
     */
    public MxReda03500101(final MxSwiftMessage mxSwiftMessage) {
        this(mxSwiftMessage.message());
    }

    /**
     * Gets the value of the sctiesAcctActvtyAdvc property.
     * 
     * @return
     *     possible object is
     *     {@link SecuritiesAccountActivityAdviceV01 }
     *     
     */
    public SecuritiesAccountActivityAdviceV01 getSctiesAcctActvtyAdvc() {
        return sctiesAcctActvtyAdvc;
    }

    /**
     * Sets the value of the sctiesAcctActvtyAdvc property.
     * 
     * @param value
     *     allowed object is
     *     {@link SecuritiesAccountActivityAdviceV01 }
     *     
     */
    public MxReda03500101 setSctiesAcctActvtyAdvc(SecuritiesAccountActivityAdviceV01 value) {
        this.sctiesAcctActvtyAdvc = value;
        return this;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

    @Override
    public boolean equals(Object that) {
        return EqualsBuilder.reflectionEquals(this, that);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public String getBusinessProcess() {
        return BUSINESS_PROCESS;
    }

    @Override
    public int getFunctionality() {
        return FUNCTIONALITY;
    }

    @Override
    public int getVariant() {
        return VARIANT;
    }

    @Override
    public int getVersion() {
        return VERSION;
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML
     * 
     */
    public static MxReda03500101 parse(String xml) {
        return ((MxReda03500101) MxReadImpl.parse(MxReda03500101 .class, xml, _classes));
    }

    /**
     * Creates the MX object parsing the raw content from the parameter XML with injected read implementation
     * @since 9.0.1
     * 
     * @param parserImpl an MX unmarshall implementation
     */
    public static MxReda03500101 parse(String xml, MxRead parserImpl) {
        return ((MxReda03500101) parserImpl.read(MxReda03500101 .class, xml, _classes));
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public Class[] getClasses() {
        return _classes;
    }

    /**
     * Creates an MxReda03500101 messages from its JSON representation.
     * <p>
     * For generic conversion of JSON into the corresponding MX instance 
     * see {@link AbstractMX#fromJson(String)}
     * 
     * @since 7.10.2
     * 
     * @param json a JSON representation of an MxReda03500101 message
     * @return
     *     a new instance of MxReda03500101
     */
    public final static MxReda03500101 fromJson(String json) {
        return AbstractMX.fromJson(json, MxReda03500101 .class);
    }

}
