/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.parser.MxParser;
import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.AbstractSwiftMessage;
import com.prowidesoftware.swift.model.FileFormat;
import com.prowidesoftware.swift.model.MessageMetadataStrategy;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.MxBusinessProcess;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AbstractMX;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrParser;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.DefaultMxMetadataStrategy;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Logger;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Entity(name="mx")
@DiscriminatorValue(value="mx")
public class MxSwiftMessage
extends AbstractSwiftMessage {
    private static final long serialVersionUID = -4394356007627575831L;
    private static final transient Logger log = Logger.getLogger(MxSwiftMessage.class.getName());
    @Enumerated(value=EnumType.STRING)
    @Column(length=4, name="business_process")
    private MxBusinessProcess businessProcess;
    @Column(length=3)
    private String functionality;
    @Column(length=3)
    private String variant;
    @Column(length=2)
    private String version;

    public MxSwiftMessage() {
    }

    public MxSwiftMessage(String xml) {
        this(xml, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(String xml, MessageMetadataStrategy metadataStrategy) {
        super(xml, FileFormat.MX, metadataStrategy);
    }

    public MxSwiftMessage(InputStream stream) throws IOException {
        this(stream, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(InputStream stream, MessageMetadataStrategy metadataStrategy) throws IOException {
        super(stream, FileFormat.MX, metadataStrategy);
    }

    public MxSwiftMessage(File file) throws IOException {
        this(file, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(File file, MessageMetadataStrategy metadataStrategy) throws IOException {
        super(file, FileFormat.MX, metadataStrategy);
    }

    public MxSwiftMessage(AbstractMX mx) {
        this(mx, (MessageMetadataStrategy)new DefaultMxMetadataStrategy());
    }

    public MxSwiftMessage(AbstractMX mx, MessageMetadataStrategy metadataStrategy) {
        Validate.notNull((Object)mx, (String)"the message model cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.setMessage(mx.message());
        this._updateFromMessage(mx.getMxId(), metadataStrategy);
    }

    public static MxSwiftMessage parse(String xml) {
        return new MxSwiftMessage(xml);
    }

    public static MxSwiftMessage parse(InputStream stream) throws IOException {
        return new MxSwiftMessage(stream);
    }

    public static MxSwiftMessage parse(File file) throws IOException {
        return new MxSwiftMessage(file);
    }

    public static MxSwiftMessage fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (MxSwiftMessage)((Object)gson.fromJson(json, MxSwiftMessage.class));
    }

    protected void updateFromMessage() {
        this._updateFromMessage(null, new DefaultMxMetadataStrategy());
    }

    protected void updateFromMessage(MessageMetadataStrategy metadataStrategy) {
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this._updateFromMessage(null, metadataStrategy);
    }

    private void _updateFromMessage(MxId id, MessageMetadataStrategy metadataStrategy) {
        if (this.message() != null && this.message().length() > 0) {
            MxId identifier = id != null ? id : (MxId)MxParseUtils.identifyMessage(this.message()).orElse(null);
            this.extractMetadata(identifier, this.getAppHdr(), metadataStrategy);
        }
    }

    public void updateFromModel(AbstractMX mx) {
        this.updateFromModel(mx, new DefaultMxMetadataStrategy());
    }

    public void updateFromModel(AbstractMX mx, MessageMetadataStrategy metadataStrategy) {
        Validate.notNull((Object)mx, (String)"the mx parameter cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.setMessage(mx.message());
        this.setFileFormat(FileFormat.MX);
        this.extractMetadata(mx.getMxId(), mx.getAppHdr(), metadataStrategy);
    }

    private void extractMetadata(MxId identifier, AppHdr headerModel, MessageMetadataStrategy metadataStrategy) {
        MxNode parsedMessage = MxNode.parse(this.message());
        if (headerModel == null || !this.extractMetadata(headerModel)) {
            this.extractMetadata(parsedMessage);
        }
        if (identifier != null) {
            this.identifier = identifier.id();
            this.businessProcess = identifier.getBusinessProcess();
            this.functionality = identifier.getFunctionality();
            this.variant = identifier.getVariant();
            this.version = identifier.getVersion();
        }
        this.applyStrategy(this.getMessage(), metadataStrategy);
    }

    private boolean extractMetadata(AppHdr h) {
        boolean updated = false;
        if (h != null) {
            String to;
            String from = h.from();
            if (from != null) {
                this.sender = this.bic11(from);
                updated = true;
            }
            if ((to = h.to()) != null) {
                this.receiver = this.bic11(to);
                updated = true;
            }
        }
        return updated;
    }

    private boolean extractMetadata(MxNode n) {
        MxNode groupHeader;
        boolean updated = false;
        MxNode mxNode = groupHeader = n != null ? n.findFirstByName("GrpHdr") : null;
        if (groupHeader != null) {
            MxNode receiverBic;
            MxNode senderBic = groupHeader.findFirst("./InstgAgt/FinInstnId/BIC");
            if (senderBic != null) {
                this.sender = this.bic11(senderBic.getValue());
                updated = true;
            }
            if ((receiverBic = groupHeader.findFirst("./InstdAgt/FinInstnId/BIC")) != null) {
                this.receiver = this.bic11(receiverBic.getValue());
                updated = true;
            }
        }
        return updated;
    }

    public void updateFromXML(String xml) {
        this.updateFromXML(xml, null);
    }

    public void updateFromXML(String xml, MxId id) {
        this.updateFromXML(xml, id, new DefaultMxMetadataStrategy());
    }

    public void updateFromXML(String xml, MxId id, MessageMetadataStrategy metadataStrategy) {
        Validate.notNull((Object)xml, (String)"the xml message parameter cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)metadataStrategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.setMessage(xml);
        this.setFileFormat(FileFormat.MX);
        this._updateFromMessage(id, metadataStrategy);
    }

    public MxBusinessProcess getBusinessProcess() {
        return this.businessProcess;
    }

    public void setBusinessProcess(MxBusinessProcess businessProcess) {
        this.businessProcess = businessProcess;
    }

    public String getFunctionality() {
        return this.functionality;
    }

    public void setFunctionality(String functionality) {
        this.functionality = functionality;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MxSwiftMessage that = (MxSwiftMessage)((Object)o);
        return this.businessProcess == that.businessProcess && Objects.equals(this.functionality, that.functionality) && Objects.equals(this.variant, that.variant) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.businessProcess, this.functionality, this.variant, this.version});
    }

    @Deprecated
    public BusinessHeader getBusinessHeader() {
        DeprecationUtils.phase2(MxSwiftMessage.class, (String)"getBusinessHeader()", (String)"Use getAppHdr() instead");
        MxParser parser = new MxParser(this.message());
        return parser.parseBusinessHeader();
    }

    public AppHdr getAppHdr() {
        return AppHdrParser.parse(this.message()).orElse(null);
    }

    public void copyTo(MxSwiftMessage msg) {
        super.copyTo((AbstractSwiftMessage)msg);
        msg.setBusinessProcess(this.getBusinessProcess());
        msg.setFunctionality(this.getFunctionality());
        msg.setVariant(this.getVariant());
        msg.setVersion(this.getVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MxSwiftMessage id=").append(this.getId()).append(" message=").append(this.getMessage());
        return sb.toString();
    }

    public MxId getMxId() {
        return new MxId(this.businessProcess, this.functionality, this.variant, this.version);
    }

    public String getCategory() {
        MxBusinessProcess proc;
        if (!StringUtils.isBlank((CharSequence)this.identifier) && (proc = new MxId(this.identifier).getBusinessProcess()) != null) {
            return proc.name();
        }
        return "";
    }

    public void updateMetadata(MessageMetadataStrategy strategy) {
        Validate.notNull((Object)strategy, (String)"the strategy for metadata extraction cannot be null", (Object[])new Object[0]);
        this.applyStrategy(this.getMessage(), strategy);
    }

    private void applyStrategy(String xml, MessageMetadataStrategy strategy) {
        Calendar tradeDate;
        Calendar valueDate;
        Optional money;
        AbstractMX mx;
        boolean isKnownType = this.businessProcess != null && this.functionality != null && this.variant != null && this.version != null;
        AbstractMX abstractMX = mx = isKnownType ? AbstractMX.parse(xml, this.getMxId()) : AbstractMX.parse(xml);
        if (mx == null) {
            return;
        }
        String reference = strategy.reference((AbstractMessage)mx).orElse(null);
        if (StringUtils.isNotBlank((CharSequence)reference)) {
            this.setReference(reference);
        }
        if ((money = strategy.amount((AbstractMessage)mx)).isPresent()) {
            this.setCurrency(((Money)money.get()).getCurrency());
            this.setAmount(((Money)money.get()).getAmount());
        }
        if ((valueDate = (Calendar)strategy.valueDate((AbstractMessage)mx).orElse(null)) != null) {
            this.setValueDate(valueDate);
        }
        if ((tradeDate = (Calendar)strategy.tradeDate((AbstractMessage)mx).orElse(null)) != null) {
            this.setTradeDate(tradeDate);
        }
    }
}

