/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.JsonSerializable;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.MessageStandardType;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.mx.AbstractMXAdapter;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrAdapter;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV01;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.EscapeHandler;
import com.prowidesoftware.swift.model.mx.IDocument;
import com.prowidesoftware.swift.model.mx.JaxbContextLoader;
import com.prowidesoftware.swift.model.mx.LegacyAppHdr;
import com.prowidesoftware.swift.model.mx.MxReadImpl;
import com.prowidesoftware.swift.model.mx.MxWriteConfiguration;
import com.prowidesoftware.swift.model.mx.MxWriteImpl;
import com.prowidesoftware.swift.model.mx.XMLGregorianCalendarAdapter;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV01;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public abstract class AbstractMX
extends AbstractMessage
implements IDocument,
JsonSerializable {
    private static final transient Logger log = Logger.getLogger(AbstractMX.class.getName());
    public static final String DOCUMENT_LOCALNAME = "Document";
    public static String DEFAULT_ROOT_ELEMENT = "RequestPayload";
    private AppHdr appHdr;

    protected AbstractMX() {
        super(MessageStandardType.MX);
    }

    protected AbstractMX(AppHdr appHdr) {
        super(MessageStandardType.MX);
        this.appHdr = appHdr;
    }

    @Deprecated
    protected static String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration) {
        return AbstractMX.message(namespace, obj, classes, prefix, includeXMLDeclaration, null);
    }

    protected static String message(String namespace, AbstractMX obj, Class[] classes, String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        return MxWriteImpl.write(namespace, obj, classes, prefix, includeXMLDeclaration, escapeHandler);
    }

    protected static AbstractMX read(Class<? extends AbstractMX> targetClass, String xml, Class[] classes) {
        return MxReadImpl.parse(targetClass, xml, classes);
    }

    public static AbstractMX parse(String xml) {
        return AbstractMX.parse(xml, null);
    }

    public static AbstractMX parse(String xml, MxId id) {
        return MxReadImpl.parse(xml, id);
    }

    public static AbstractMX parse(File file, MxId id) throws IOException {
        return AbstractMX.parse(Lib.readFile((File)file), id);
    }

    public static AbstractMX parse(Element e) {
        String prefix = e.getPrefix();
        if (prefix != null) {
            NamedNodeMap attributes = e.getAttributes();
            ArrayList<Node> removables = new ArrayList<Node>();
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                if (StringUtils.equals((CharSequence)attr.getNodeName(), (CharSequence)("xmlns:" + prefix)) || StringUtils.equals((CharSequence)attr.getNodeName(), (CharSequence)"xmlns:xsi")) continue;
                removables.add(attr);
            }
            for (Node attr : removables) {
                attributes.removeNamedItem(attr.getNodeName());
            }
        }
        DOMImplementationLS lsImpl = (DOMImplementationLS)e.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String xml = serializer.writeToString(e);
        if (e.getNamespaceURI() != null) {
            return AbstractMX.parse(xml, new MxId(e.getNamespaceURI()));
        }
        return null;
    }

    protected static <T> T fromJson(String json, Class<T> classOfT) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarAdapter()).registerTypeAdapter(AppHdr.class, (Object)new AppHdrAdapter()).create();
        return (T)gson.fromJson(json, classOfT);
    }

    public static AbstractMX fromJson(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarAdapter()).registerTypeAdapter(AppHdr.class, (Object)new AppHdrAdapter()).create();
        return (AbstractMX)gson.fromJson(json, AbstractMX.class);
    }

    public abstract Class[] getClasses();

    public abstract String getNamespace();

    public abstract String getBusinessProcess();

    public abstract int getFunctionality();

    public abstract int getVariant();

    public abstract int getVersion();

    public String message() {
        return this.message((MxWriteConfiguration)null);
    }

    @Deprecated
    public String message(String rootElement, boolean includeXMLDeclaration) {
        MxWriteConfiguration conf = new MxWriteConfiguration();
        conf.rootElement = rootElement;
        conf.includeXMLDeclaration = includeXMLDeclaration;
        return this.message(conf);
    }

    @Deprecated
    public String message(String rootElement) {
        MxWriteConfiguration conf = new MxWriteConfiguration();
        conf.rootElement = rootElement;
        return this.message(conf);
    }

    public String message(MxWriteConfiguration conf) {
        String header;
        MxWriteConfiguration usableConf = conf != null ? conf : new MxWriteConfiguration();
        String root = usableConf.rootElement;
        StringBuilder xml = new StringBuilder();
        if (usableConf.includeXMLDeclaration) {
            xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        }
        if ((header = this.header(usableConf.headerPrefix, false, usableConf.escapeHandler)) != null) {
            xml.append("<").append(root).append(">\n");
            xml.append(header).append("\n");
        }
        xml.append(this.document(usableConf.documentPrefix, false, usableConf.escapeHandler)).append("\n");
        if (header != null) {
            xml.append("</").append(root).append(">");
        }
        return xml.toString();
    }

    public String header() {
        return this.header(null, false, null);
    }

    @Deprecated
    public String header(String prefix, boolean includeXMLDeclaration) {
        return this.header(prefix, includeXMLDeclaration, null);
    }

    public String header(String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        if (this.appHdr != null) {
            return this.appHdr.xml(prefix, includeXMLDeclaration, escapeHandler);
        }
        return null;
    }

    public String document() {
        return this.document("Doc", true);
    }

    @Deprecated
    public String document(String prefix, boolean includeXMLDeclaration) {
        return this.document(prefix, includeXMLDeclaration, null);
    }

    public String document(String prefix, boolean includeXMLDeclaration, EscapeHandler escapeHandler) {
        return AbstractMX.message(this.getNamespace(), this, this.getClasses(), prefix, includeXMLDeclaration, escapeHandler);
    }

    public Source xmlSource() {
        String xml = this.message();
        log.fine("XML: " + xml);
        if (xml != null) {
            return new StreamSource(new StringReader(xml));
        }
        return null;
    }

    public void write(File file) throws IOException {
        Validate.notNull((Object)file, (String)"the file to write cannot be null", (Object[])new Object[0]);
        boolean created = file.createNewFile();
        if (created) {
            log.fine("new file created: " + file.getAbsolutePath());
        }
        FileOutputStream stream = new FileOutputStream(file.getAbsoluteFile());
        this.write(stream);
        stream.close();
    }

    public void write(OutputStream stream) throws IOException {
        Validate.notNull((Object)stream, (String)"the stream to write cannot be null", (Object[])new Object[0]);
        stream.write(this.message().getBytes(StandardCharsets.UTF_8));
    }

    @XmlTransient
    @Deprecated
    public BusinessHeader getBusinessHeader() {
        DeprecationUtils.phase2(AbstractMX.class, (String)"getBusinessHeader()", (String)"Use getAppHdr() instead");
        if (this.appHdr instanceof BusinessHeader) {
            return (BusinessHeader)this.appHdr;
        }
        if (this.appHdr instanceof ApplicationHeader) {
            return new BusinessHeader((ApplicationHeader)this.appHdr);
        }
        if (this.appHdr instanceof BusinessApplicationHeaderV01) {
            return new BusinessHeader((BusinessApplicationHeaderV01)this.appHdr);
        }
        if (this.appHdr instanceof LegacyAppHdr) {
            return new BusinessHeader((LegacyAppHdr)this.appHdr);
        }
        if (this.appHdr instanceof BusinessAppHdrV01) {
            return new BusinessHeader((BusinessAppHdrV01)this.appHdr);
        }
        return null;
    }

    @Deprecated
    public void setBusinessHeader(BusinessHeader businessHeader) {
        DeprecationUtils.phase2(AbstractMX.class, (String)"setBusinessHeader(BusinessHeader)", (String)"Use setAppHdr(AppHdr) instead");
        this.setAppHdr(businessHeader);
    }

    @XmlTransient
    public AppHdr getAppHdr() {
        return this.appHdr;
    }

    public void setAppHdr(AppHdr appHdr) {
        this.appHdr = appHdr;
    }

    public MxId getMxId() {
        return new MxId(this.getBusinessProcess(), StringUtils.leftPad((String)Integer.toString(this.getFunctionality()), (int)3, (String)"0"), StringUtils.leftPad((String)Integer.toString(this.getVariant()), (int)3, (String)"0"), StringUtils.leftPad((String)Integer.toString(this.getVersion()), (int)2, (String)"0"));
    }

    public Element element() {
        try {
            JAXBContext context = JaxbContextLoader.INSTANCE.get(this.getClass(), this.getClasses());
            DOMResult res = new DOMResult();
            context.createMarshaller().marshal((Object)this, (Result)res);
            Document doc = (Document)res.getNode();
            return (Element)doc.getFirstChild();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Error creating XML Document for MX", e);
            return null;
        }
    }

    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(AbstractMX.class, (Object)new AbstractMXAdapter()).registerTypeAdapter(XMLGregorianCalendar.class, (Object)new XMLGregorianCalendarAdapter()).registerTypeAdapter(AppHdr.class, (Object)new AppHdrAdapter()).setPrettyPrinting().create();
        return gson.toJson((Object)this, AbstractMX.class);
    }

    public String targetNamespace() {
        return this.getNamespace();
    }
}

