/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.io.parser;

import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.io.parser.MxBusinessHeaderParser;
import com.prowidesoftware.swift.model.MxId;
import com.prowidesoftware.swift.model.MxNode;
import com.prowidesoftware.swift.model.mx.AppHdr;
import com.prowidesoftware.swift.model.mx.AppHdrParser;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV01;
import com.prowidesoftware.swift.model.mx.BusinessHeader;
import com.prowidesoftware.swift.model.mx.LegacyAppHdr;
import com.prowidesoftware.swift.model.mx.MxParseUtils;
import com.prowidesoftware.swift.model.mx.dic.ApplicationHeader;
import com.prowidesoftware.swift.model.mx.dic.BusinessApplicationHeaderV01;
import com.prowidesoftware.swift.utils.Lib;
import com.prowidesoftware.swift.utils.SafeXmlUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

@Deprecated
public class MxParser {
    @Deprecated
    public static final String HEADER_LOCALNAME = "AppHdr";
    @Deprecated
    public static final String DOCUMENT_LOCALNAME = "Document";
    private static final Logger log = Logger.getLogger(MxParser.class.getName());
    private String buffer;
    @Deprecated
    private MxStructureInfo info = null;

    @Deprecated
    public MxParser(File file) throws IOException {
        Objects.requireNonNull(file);
        this.buffer = Lib.readFile((File)file);
        DeprecationUtils.phase2(MxParser.class, (String)"MxParser(File)", (String)"The MxParser class is no longer useful or has been replaced by similar features in AbstractMX, AppHdr, AppHdrParser, MxNode or MxParseUtils");
    }

    @Deprecated
    public MxParser(InputStream stream) throws IOException {
        this.buffer = Lib.readStream((InputStream)stream);
        DeprecationUtils.phase2(MxParser.class, (String)"MxParser(File)", (String)"The MxParser class is no longer useful or has been replaced by similar features in AbstractMX, AppHdr, AppHdrParser, MxNode or MxParseUtils");
    }

    @Deprecated
    public MxParser(String message) {
        this.buffer = message;
        DeprecationUtils.phase2(MxParser.class, (String)"MxParser(File)", (String)"The MxParser class is no longer useful or has been replaced by similar features in AbstractMX, AppHdr, AppHdrParser, MxNode or MxParseUtils");
    }

    @Deprecated
    public static BusinessHeader parseBusinessHeader(Element e) {
        DeprecationUtils.phase2(MxParser.class, (String)"parseBusinessHeader(Element)", (String)"Use AppHdrParser#parse(Element) instead");
        DOMImplementationLS lsImpl = (DOMImplementationLS)e.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer serializer = lsImpl.createLSSerializer();
        serializer.getDomConfig().setParameter("xml-declaration", false);
        String xml = serializer.writeToString(e);
        return new MxParser(xml).parseBusinessHeader();
    }

    @Deprecated
    public static AppHdr parseAppHdr(Element e) {
        DeprecationUtils.phase2(MxParser.class, (String)"parseAppHdr(Element)", (String)"Use AppHdrParser#parse(Element) instead");
        return AppHdrParser.parse(e).orElse(null);
    }

    @Deprecated
    public static ApplicationHeader parseApplicationHeader(MxNode tree) {
        DeprecationUtils.phase2(MxParser.class, (String)"parseApplicationHeader(MxNode)", (String)"Use LegacyAppHdr#parse(String) instead");
        return MxBusinessHeaderParser.parseApplicationHeader(tree);
    }

    @Deprecated
    public static BusinessApplicationHeaderV01 parseBusinessApplicationHeaderV01(MxNode tree) {
        DeprecationUtils.phase2(MxParser.class, (String)"parseBusinessApplicationHeaderV01(MxNode)", (String)"Use BusinessAppHdrV01#parse(String) instead");
        return MxBusinessHeaderParser.parseBusinessApplicationHeaderV01(tree);
    }

    @Deprecated
    public static String getBICFromDN(String dn) {
        DeprecationUtils.phase2(MxParser.class, (String)"getBICFromDN(String)", (String)"Use MxParseUtils#getBICFromDN(String) instead");
        return MxParseUtils.getBICFromDN(dn);
    }

    @Deprecated
    public MxNode parse() {
        DeprecationUtils.phase2(MxParser.class, (String)"parse()", (String)"Use MxNode#parse(String) instead");
        return MxNode.parse(this.buffer);
    }

    @Deprecated
    public BusinessHeader parseBusinessHeader() {
        DeprecationUtils.phase2(MxParser.class, (String)"parseBusinessHeader()", (String)"Use AppHdrParser#parse(String) instead");
        Optional<AppHdr> appHdr = AppHdrParser.parse(this.buffer);
        if (appHdr.isPresent()) {
            return null;
        }
        if (appHdr.get() instanceof LegacyAppHdr) {
            return new BusinessHeader((LegacyAppHdr)appHdr.get());
        }
        if (appHdr.get() instanceof BusinessAppHdrV01) {
            return new BusinessHeader((BusinessAppHdrV01)appHdr.get());
        }
        return null;
    }

    @Deprecated
    public AppHdr parseAppHdr() {
        DeprecationUtils.phase2(MxParser.class, (String)"parseAppHdr()", (String)"Use AppHdrParser#parse(String) instead");
        return AppHdrParser.parse(this.buffer).orElse(null);
    }

    @Deprecated
    public ApplicationHeader parseApplicationHeader() {
        DeprecationUtils.phase2(MxParser.class, (String)"parseApplicationHeader()", (String)"Use LegacyAppHdr#parse(String) instead");
        LegacyAppHdr legacyHdr = LegacyAppHdr.parse(this.buffer);
        ApplicationHeader result = new ApplicationHeader();
        result.setFrom(legacyHdr.getFrom());
        result.setTo(legacyHdr.getTo());
        result.setSvcName(legacyHdr.getSvcName());
        result.setMsgName(legacyHdr.getMsgName());
        result.setMsgRef(legacyHdr.getMsgRef());
        result.setCrDate(legacyHdr.getCrDate());
        result.setDup(legacyHdr.getDup());
        return result;
    }

    @Deprecated
    public BusinessApplicationHeaderV01 parseBusinessApplicationHeaderV01() {
        DeprecationUtils.phase2(MxParser.class, (String)"parseApplicationHeader()", (String)"Use BusinessAppHdrV01#parse(String) instead");
        BusinessAppHdrV01 businessAppHdrV01 = BusinessAppHdrV01.parse(this.buffer);
        BusinessApplicationHeaderV01 result = new BusinessApplicationHeaderV01();
        result.setCharSet(businessAppHdrV01.getCharSet());
        result.setFr(businessAppHdrV01.getFr());
        result.setTo(businessAppHdrV01.getTo());
        result.setBizMsgIdr(businessAppHdrV01.getBizMsgIdr());
        result.setMsgDefIdr(businessAppHdrV01.getMsgDefIdr());
        result.setBizSvc(businessAppHdrV01.getBizSvc());
        result.setCreDt(businessAppHdrV01.getCreDt());
        result.setCpyDplct(businessAppHdrV01.getCpyDplct());
        result.setPssblDplct(businessAppHdrV01.isPssblDplct());
        result.setPrty(businessAppHdrV01.getPrty());
        result.setSgntr(businessAppHdrV01.getSgntr());
        result.setRltd(businessAppHdrV01.getRltd());
        return result;
    }

    @Deprecated
    public MxId detectMessage() {
        DeprecationUtils.phase2(MxParser.class, (String)"detectMessage()", (String)"Use MxParseUtils#identifyMessage(String) instead");
        if (StringUtils.isBlank((CharSequence)this.buffer)) {
            log.log(Level.SEVERE, "cannot detect message from null or empty content");
            return null;
        }
        Optional<MxId> id = MxParseUtils.identifyMessage(this.buffer);
        return id.orElse(null);
    }

    @Deprecated
    public MxStructureInfo analyzeMessage() {
        if (this.info != null) {
            return this.info;
        }
        this.info = new MxStructureInfo();
        if (StringUtils.isBlank((CharSequence)this.buffer)) {
            log.log(Level.WARNING, "cannot analyze message from null or empty content");
            return this.info;
        }
        XMLInputFactory xif = SafeXmlUtils.inputFactory();
        try {
            XMLStreamReader reader = xif.createXMLStreamReader(new StringReader(this.buffer));
            boolean first = true;
            while (reader.hasNext()) {
                int event = reader.next();
                if (1 != event) continue;
                if (!this.info.containsDocument && reader.getLocalName().equals(DOCUMENT_LOCALNAME)) {
                    this.info.containsDocument = true;
                    this.info.documentNamespace = this.readNamespace(reader);
                    this.info.documentPrefix = StringUtils.trimToNull((String)reader.getPrefix());
                } else if (!this.info.containsHeader && reader.getLocalName().equals(HEADER_LOCALNAME)) {
                    this.info.containsHeader = true;
                    this.info.headerNamespace = this.readNamespace(reader);
                    this.info.headerPrefix = StringUtils.trimToNull((String)reader.getPrefix());
                } else if (first) {
                    this.info.containsWrapper = true;
                }
                first = false;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "error while analyzing message: " + e.getMessage());
            this.info.exception = e;
        }
        return this.info;
    }

    @Deprecated
    private String readNamespace(XMLStreamReader reader) {
        DeprecationUtils.phase2(MxParser.class, (String)"readNamespace(XMLStreamReader)", (String)"If you just want to detect the message type you can also use the MxParseUtils#identifyMessage(String)");
        if (reader.getNamespaceCount() > 0) {
            for (int nsIndex = 0; nsIndex < reader.getNamespaceCount(); ++nsIndex) {
                String elementPrefix;
                String nsPrefix = StringUtils.trimToNull((String)reader.getNamespacePrefix(nsIndex));
                if (!StringUtils.equals((CharSequence)nsPrefix, (CharSequence)(elementPrefix = StringUtils.trimToNull((String)reader.getPrefix())))) continue;
                return reader.getNamespaceURI(nsIndex);
            }
        }
        return null;
    }

    @Deprecated
    public String stripDocument() {
        DeprecationUtils.phase2(MxParser.class, (String)"stripDocument()", (String)"Parse the message using AbstractMX#parse(String) instead, and then use any of the document serializer methods such as AbstractMX#document()");
        this.analyzeMessage();
        if (this.info.containsDocument) {
            String tag = this.info.getDocumentPrefix() != null ? this.info.getDocumentPrefix() + ":" + DOCUMENT_LOCALNAME : DOCUMENT_LOCALNAME;
            int beginIndex = this.buffer.indexOf("<" + tag);
            int endIndex = this.buffer.lastIndexOf("</" + tag);
            if (beginIndex >= 0 && endIndex >= 0) {
                return this.buffer.substring(beginIndex, endIndex) + "</" + tag + ">";
            }
        }
        return null;
    }

    @Deprecated
    public String stripHeader() {
        DeprecationUtils.phase2(MxParseUtils.class, (String)"stripHeader()", (String)"Parse the message using AbstractMX#parse(String) instead, and then use any of the header serializer methods such as AbstractMX#header()");
        this.analyzeMessage();
        if (this.info.containsHeader()) {
            String tag = this.info.getHeaderPrefix() != null ? this.info.getHeaderPrefix() + ":" + HEADER_LOCALNAME : HEADER_LOCALNAME;
            int beginIndex = this.buffer.indexOf("<" + tag);
            int endIndex = this.buffer.indexOf("</" + tag);
            if (beginIndex >= 0 && endIndex >= 0) {
                return this.buffer.substring(beginIndex, endIndex) + "</" + tag + ">";
            }
        }
        return null;
    }

    @Deprecated
    public class MxStructureInfo {
        private boolean containsWrapper = false;
        private boolean containsHeader = false;
        private boolean containsDocument = false;
        private String documentNamespace = null;
        private String documentPrefix = null;
        private String headerNamespace = null;
        private String headerPrefix = null;
        private Exception exception = null;

        public boolean containsWrapper() {
            return this.containsWrapper;
        }

        public boolean containsHeader() {
            return this.containsHeader;
        }

        public boolean containsDocument() {
            return this.containsDocument;
        }

        public String getDocumentNamespace() {
            return this.documentNamespace;
        }

        public String getDocumentPrefix() {
            return this.documentPrefix;
        }

        public String getHeaderNamespace() {
            return this.headerNamespace;
        }

        public String getHeaderPrefix() {
            return this.headerPrefix;
        }

        public Exception getException() {
            return this.exception;
        }

        public Optional<Boolean> containsLegacyHeader() {
            if (this.containsHeader) {
                return Optional.of(StringUtils.contains((CharSequence)this.headerNamespace, (CharSequence)"ahV10"));
            }
            return Optional.empty();
        }

        public String toString() {
            return "MxStructureInfo [containsWrapper=" + this.containsWrapper + ", containsHeader=" + this.containsHeader + ", containsDocument=" + this.containsDocument + ", documentNamespace=" + this.documentNamespace + ", documentPrefix=" + this.documentPrefix + ", headerNamespace=" + this.headerNamespace + ", headerPrefix=" + this.headerPrefix + "]";
        }
    }
}

