/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx;

import com.prowidesoftware.swift.model.mx.BusinessAppHdrV01;
import com.prowidesoftware.swift.model.mx.BusinessAppHdrV02;
import com.prowidesoftware.swift.model.mx.LegacyAppHdr;
import org.apache.commons.lang3.StringUtils;

public enum AppHdrType {
    LEGACY("urn:swift:xsd:$ahV10", LegacyAppHdr.class),
    BAH_V1("urn:iso:std:iso:20022:tech:xsd:head.001.001.01", BusinessAppHdrV01.class),
    BAH_V2("urn:iso:std:iso:20022:tech:xsd:head.001.001.02", BusinessAppHdrV02.class);

    private String namespace;
    private Class headerClass;

    private AppHdrType(String namespace, Class headerClass) {
        this.namespace = namespace;
        this.headerClass = headerClass;
    }

    public static Class of(String namespace) {
        if (StringUtils.isNotBlank((CharSequence)namespace)) {
            for (AppHdrType appHdrType : AppHdrType.values()) {
                if (!namespace.equals(appHdrType.getNamespace())) continue;
                return appHdrType.headerClass;
            }
        }
        return null;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

