/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import com.prowidesoftware.swift.model.mx.adapters.AdapterUtils;
import java.text.SimpleDateFormat;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.XMLGregorianCalendar;

public class SimpleDateAdapter
extends XmlAdapter<String, XMLGregorianCalendar> {
    private final SimpleDateFormat dateFormat;
    private final XmlAdapter<String, XMLGregorianCalendar> customAdapterImpl;

    public SimpleDateAdapter() {
        this.dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.customAdapterImpl = null;
    }

    public SimpleDateAdapter(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
        this.customAdapterImpl = null;
    }

    public SimpleDateAdapter(XmlAdapter<String, XMLGregorianCalendar> customAdapterImpl) {
        this.dateFormat = null;
        this.customAdapterImpl = customAdapterImpl;
    }

    public XMLGregorianCalendar unmarshal(String value) throws Exception {
        if (this.customAdapterImpl != null) {
            return (XMLGregorianCalendar)this.customAdapterImpl.unmarshal((Object)value);
        }
        return AdapterUtils.parse(this.dateFormat, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String marshal(XMLGregorianCalendar cal) throws Exception {
        if (this.customAdapterImpl != null) {
            return (String)this.customAdapterImpl.marshal((Object)cal);
        }
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return AdapterUtils.format(this.dateFormat, cal);
        }
    }
}

