
package com.prowidesoftware.swift.model.mx.dic;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for ClearingChannel2Code.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="ClearingChannel2Code"&gt;
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string"&gt;
 *     &lt;enumeration value="RTGS"/&gt;
 *     &lt;enumeration value="RTNS"/&gt;
 *     &lt;enumeration value="MPNS"/&gt;
 *     &lt;enumeration value="BOOK"/&gt;
 *   &lt;/restriction&gt;
 * &lt;/simpleType&gt;
 * </pre>
 * 
 */
@XmlType(name = "ClearingChannel2Code")
@XmlEnum
public enum ClearingChannel2Code {


    /**
     * Clearing channel is a real-time gross settlement system.
     * 
     */
    RTGS,

    /**
     * Clearing channel is a real-time net settlement system.
     * 
     */
    RTNS,

    /**
     * Clearing channel is a mass payment net settlement system.
     * 
     */
    MPNS,

    /**
     * Payment through internal book transfer.
     * 
     */
    BOOK;

    public String value() {
        return name();
    }

    public static ClearingChannel2Code fromValue(String v) {
        return valueOf(v);
    }

}
